/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine;

import com.feed_the_beast.mods.ftbultimine.FTBUltimineConfig;
import com.feed_the_beast.mods.ftbultimine.shape.BlockMatcher;
import com.feed_the_beast.mods.ftbultimine.shape.Shape;
import com.feed_the_beast.mods.ftbultimine.shape.ShapeContext;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class FTBUltiminePlayerData {
    public final UUID id;
    public boolean pressed = false;
    public Shape shape = Shape.get("");
    public BlockPos cachedPos;
    public EnumFacing cachedDirection;
    public List<BlockPos> cachedBlocks;
    public boolean prevSneaking;

    public FTBUltiminePlayerData(UUID i) {
        this.id = i;
    }

    public void clearCache() {
        this.cachedPos = null;
        this.cachedDirection = null;
        this.cachedBlocks = null;
    }

    @Nullable
    public ShapeContext updateBlocks(EntityPlayerMP player, BlockPos p, EnumFacing d, int maxBlocks) {
        ShapeContext context = null;
        this.cachedPos = p;
        this.cachedDirection = d;
        if (maxBlocks <= 0) {
            this.cachedBlocks = Collections.emptyList();
        } else {
            context = new ShapeContext();
            context.player = player;
            context.pos = this.cachedPos;
            context.face = this.cachedDirection;
            context.matcher = BlockMatcher.MATCH;
            context.maxBlocks = maxBlocks;
            context.original = player.field_70170_p.func_180495_p(this.cachedPos);
            if (FTBUltimineConfig.mergeStone && BlockMatcher.ANY_STONE.check(context.original, context.original)) {
                context.matcher = BlockMatcher.ANY_STONE;
            } else if (BlockMatcher.REDSTONE_ORE.check(context.original, context.original)) {
                context.matcher = BlockMatcher.REDSTONE_ORE;
            } else if (BlockMatcher.BUSH.check(context.original, context.original)) {
                context.matcher = BlockMatcher.BUSH;
            }
            this.cachedBlocks = this.shape.getBlocks(context);
        }
        return context;
    }
}

