/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.packet.KeypadServerPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.WavefrontObjDisplayList;
import com.hbm.render.amlfrom1710.WavefrontObject;
import com.hbm.util.Keypad;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class KeypadClient
extends Keypad {
    public static final FloatBuffer AUX_GL_MATRIX = GLAllocation.func_74529_h((int)16);
    public static int fullModel;
    public static int mainModel;
    public static int displayModel;
    public static int[] keyModels;
    public Matrix4f transform;
    public AxisAlignedBB[] buttonBoxes = new AxisAlignedBB[12];
    public AxisAlignedBB[] pressedButtonBoxes = new AxisAlignedBB[12];
    public AxisAlignedBB mainBox;

    public KeypadClient(TileEntity te, Matrix4f transform) {
        super(te);
        this.transform = transform;
        for (int x = 0; x < 3; ++x) {
            for (int y = 3; y >= 0; --y) {
                Vector4f pos1 = new Vector4f(0.3125f - 0.234375f * (float)x, 0.042969f + 0.175781f * (float)y, 0.0f, 1.0f);
                Vector4f pos2 = new Vector4f(0.15625f - 0.234375f * (float)x, 0.160156f + 0.175781f * (float)y, -0.0625f, 1.0f);
                Vector4f pos2_pressed = new Vector4f(0.15625f - 0.234375f * (float)x, 0.160156f + 0.175781f * (float)y, -0.0125f, 1.0f);
                Matrix4f.transform((Matrix4f)transform, (Vector4f)pos1, (Vector4f)pos1);
                Matrix4f.transform((Matrix4f)transform, (Vector4f)pos2, (Vector4f)pos2);
                Matrix4f.transform((Matrix4f)transform, (Vector4f)pos2_pressed, (Vector4f)pos2_pressed);
                this.buttonBoxes[(3 - y) * 3 + x] = new AxisAlignedBB((double)(pos1.x + 0.5f), (double)pos1.y, (double)(pos1.z + 0.5f), (double)(pos2.x + 0.5f), (double)pos2.y, (double)(pos2.z + 0.5f));
                this.pressedButtonBoxes[(3 - y) * 3 + x] = new AxisAlignedBB((double)(pos1.x + 0.5f), (double)pos1.y, (double)(pos1.z + 0.5f), (double)(pos2_pressed.x + 0.5f), (double)pos2_pressed.y, (double)(pos2_pressed.z + 0.5f));
            }
        }
        Vector4f pos1 = new Vector4f(-0.375f, 0.0f, 0.0f, 1.0f);
        Vector4f pos2 = new Vector4f(0.375f, 1.0f, -0.0625f, 1.0f);
        Matrix4f.transform((Matrix4f)transform, (Vector4f)pos1, (Vector4f)pos1);
        Matrix4f.transform((Matrix4f)transform, (Vector4f)pos2, (Vector4f)pos2);
        this.mainBox = new AxisAlignedBB((double)(pos1.x + 0.5f), (double)pos1.y, (double)(pos1.z + 0.5f), (double)(pos2.x + 0.5f), (double)pos2.y, (double)(pos2.z + 0.5f));
    }

    public boolean playerClick(BlockPos pos) {
        int idx = this.rayTraceForButtonIndex(pos);
        if (idx >= 0) {
            Keypad.Button b = this.buttons[idx];
            if (b.cooldown == 0) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new KeypadServerPacket(pos, 0, idx));
                return true;
            }
        }
        return false;
    }

    public AxisAlignedBB rayTrace(BlockPos pos) {
        int idx = this.rayTraceForButtonIndex(pos);
        if (idx < 0) {
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            Vec3d vec1 = p.func_174824_e(MainRegistry.proxy.partialTicks());
            Vec3d vec2 = vec1.func_178787_e(p.func_70676_i(MainRegistry.proxy.partialTicks()).func_186678_a(3.0));
            RayTraceResult r = this.mainBox.func_186670_a(pos).func_72327_a(vec1, vec2);
            if (r != null && r.field_72313_a != RayTraceResult.Type.MISS) {
                return this.mainBox.func_186670_a(pos);
            }
            return null;
        }
        if (this.buttons[idx].cooldown == 0) {
            return this.buttonBoxes[idx].func_186670_a(pos);
        }
        return this.pressedButtonBoxes[idx].func_186670_a(pos);
    }

    public int rayTraceForButtonIndex(BlockPos pos) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        Vec3d vec1 = p.func_174824_e(MainRegistry.proxy.partialTicks());
        Vec3d vec2 = vec1.func_178787_e(p.func_70676_i(MainRegistry.proxy.partialTicks()).func_186678_a(3.0));
        int idx = -1;
        RayTraceResult hit = null;
        for (int i = 0; i < this.buttonBoxes.length; ++i) {
            RayTraceResult r = this.buttonBoxes[i].func_186670_a(pos).func_72327_a(vec1, vec2);
            if (r == null || r.field_72313_a == RayTraceResult.Type.MISS || hit != null && !(r.field_72307_f.func_72436_e(vec1) < hit.field_72307_f.func_72436_e(vec1))) continue;
            hit = r;
            idx = i;
        }
        return idx;
    }

    public boolean isPlayerMouseingOver(BlockPos pos) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        Vec3d vec1 = p.func_174824_e(MainRegistry.proxy.partialTicks());
        Vec3d vec2 = vec1.func_178787_e(p.func_70676_i(MainRegistry.proxy.partialTicks()).func_186678_a(3.0));
        RayTraceResult r = this.mainBox.func_186670_a(pos).func_72327_a(vec1, vec2);
        return r != null && r.field_72313_a != RayTraceResult.Type.MISS;
    }

    public static void load() {
        WavefrontObjDisplayList model = new WavefrontObjDisplayList(new WavefrontObject(new ResourceLocation("hbm", "models/keypad.obj")));
        mainModel = model.getListForName("Keypad");
        displayModel = model.getListForName("Display");
        for (int i = 0; i < 9; ++i) {
            KeypadClient.keyModels[i] = model.getListForName("K" + (i + 1));
        }
        KeypadClient.keyModels[9] = model.getListForName("KReset");
        KeypadClient.keyModels[10] = model.getListForName("K0");
        KeypadClient.keyModels[11] = model.getListForName("KReturn");
        fullModel = GL11.glGenLists((int)1);
        GL11.glNewList((int)fullModel, (int)4864);
        model.renderAll();
        GL11.glEndList();
    }

    public void render() {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.keypad_tex);
        GlStateManager.func_179091_B();
        this.transform.store(AUX_GL_MATRIX);
        AUX_GL_MATRIX.rewind();
        GL11.glMultMatrix((FloatBuffer)AUX_GL_MATRIX);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String disp = "";
        if (this.isActive()) {
            if (this.isSettingCode) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.keypad_tex);
            } else if (this.successColorTicks > 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.keypad_success_tex);
            } else if (this.failColorTicks > 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.keypad_error_tex);
            }
            GL11.glCallList((int)mainModel);
            GL11.glCallList((int)displayModel);
            for (int i = 0; i < this.buttons.length; ++i) {
                GL11.glPushMatrix();
                if (this.buttons[i].cooldown > 0) {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)0.05);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.keypad_success_tex);
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.keypad_tex);
                }
                GL11.glCallList((int)keyModels[i]);
                GL11.glPopMatrix();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL11.glCallList((int)fullModel);
        }
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.275, (double)0.67, (double)-0.0625);
        float s = 0.02f;
        GL11.glScaled((double)((double)s * 0.5), (double)((double)(-s) * 0.5), (double)s);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        for (int i = 0; i < 12; ++i) {
            switch (i) {
                case 9: {
                    disp = "R";
                    break;
                }
                case 10: {
                    disp = "0";
                    break;
                }
                case 11: {
                    disp = "E";
                    break;
                }
                default: {
                    disp = "" + (i + 1);
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)((float)(i % 3) * 0.234375f * 100.0f), (double)((float)(i / 3) * 0.175781f * 100.0f), (double)0.0);
            if (this.buttons[i].cooldown > 0) {
                GL11.glTranslated((double)0.0, (double)0.0, (double)-2.5);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            font.func_78276_b(disp, 0, 0, -12566464);
            GL11.glPopMatrix();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        int code = this.buildIntCode();
        if (code < 0) {
            GL11.glTranslated((double)0.3, (double)0.92, (double)0.03125);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            if (this.isSettingCode) {
                GL11.glScaled((double)(s * 0.5f), (double)((double)(-s) * 0.5), (double)s);
                font.func_78276_b("Enter New", 0, 0, -4608);
                GL11.glTranslated((double)0.0, (double)8.0, (double)0.0);
                font.func_78276_b("Code:", 0, 0, -4608);
            } else if (this.successColorTicks > 0) {
                GL11.glScaled((double)(s * 0.5f), (double)((double)(-s) * 0.5), (double)s);
                font.func_78276_b("Access", 0, 0, -15335680);
                GL11.glTranslated((double)0.0, (double)8.0, (double)0.0);
                font.func_78276_b("Granted", 0, 0, -15335680);
            } else if (this.failColorTicks > 0) {
                GL11.glScaled((double)(s * 0.5f), (double)((double)(-s) * 0.5), (double)s);
                font.func_78276_b("Access", 0, 0, -63488);
                GL11.glTranslated((double)0.0, (double)8.0, (double)0.0);
                font.func_78276_b("Denied", 0, 0, -63488);
            } else {
                GL11.glTranslated((double)0.0, (double)-0.035, (double)0.0);
                GL11.glScaled((double)(s * 0.5f), (double)((double)(-s) * 0.5), (double)s);
                font.func_78276_b("Enter Code:", 0, 0, -1);
            }
        } else {
            GL11.glTranslated((double)0.3, (double)0.91, (double)0.03125);
            GL11.glScaled((double)((double)s * 0.85), (double)((double)(-s) * 0.9), (double)s);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            if (this.isSettingCode) {
                font.func_78276_b("" + code, 0, 0, -4608);
            } else {
                font.func_78276_b("" + code, 0, 0, -1);
            }
        }
        GlStateManager.func_179113_r();
        GlStateManager.func_179101_C();
        GL11.glPopMatrix();
    }

    static {
        keyModels = new int[12];
    }
}

