/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackUtil {
    public static ItemStack carefulCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77946_l();
    }

    @Nonnull
    public static ItemStack[] carefulCopyArrayTruncate(@Nonnull IItemHandler inv, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end must be >= start");
        }
        int length = end - start + 1;
        ItemStack[] copy = new ItemStack[length];
        for (int idx = 0; idx < length; ++idx) {
            copy[idx] = ItemStackUtil.carefulCopy(inv.getStackInSlot(start + idx));
        }
        return copy;
    }

    public static ItemStack carefulCopyWithSize(ItemStack stack, int size) {
        if (stack == null) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(size);
        return copy;
    }

    public static ItemStack[] carefulCopyArray(ItemStack[] array) {
        return ItemStackUtil.carefulCopyArray(array, 0, array.length - 1);
    }

    public static ItemStack[] carefulCopyArray(ItemStack[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        ItemStack[] copy = new ItemStack[array.length];
        for (int i = start; i <= end; ++i) {
            copy[i] = ItemStackUtil.carefulCopy(array[i]);
        }
        return copy;
    }

    public static ItemStack[] carefulCopyArrayTruncate(ItemStack[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        int length = end - start + 1;
        ItemStack[] copy = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            copy[i] = ItemStackUtil.carefulCopy(array[start + i]);
        }
        return copy;
    }

    public static void addTooltipToStack(ItemStack stack, String ... lines) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound display = new NBTTagCompound();
        NBTTagList lore = new NBTTagList();
        for (String line : lines) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.RESET + "" + TextFormatting.GRAY + line));
        }
        display.func_74782_a("Lore", (NBTBase)lore);
        stack.func_77978_p().func_74782_a("display", (NBTBase)display);
    }

    public static void addStacksToNBT(ItemStack stack, ItemStack ... stacks) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74774_a("slot", (byte)i);
            stacks[i].func_77955_b(slotNBT);
            tags.func_74742_a((NBTBase)slotNBT);
        }
        stack.func_77978_p().func_74782_a("items", (NBTBase)tags);
    }

    public static ItemStack[] readStacksFromNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("items", 10);
        int count = list.func_74745_c();
        ItemStack[] stacks = new ItemStack[count];
        for (int i = 0; i < count; ++i) {
            NBTTagCompound slotNBT = list.func_150305_b(i);
            byte slot = slotNBT.func_74771_c("slot");
            if (slot < 0 || slot >= stacks.length) continue;
            stacks[slot] = new ItemStack(slotNBT);
        }
        return stacks;
    }

    public static List<String> getOreDictNames(ItemStack stack) {
        int[] ids;
        ArrayList<String> list = new ArrayList<String>();
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)i));
        }
        return list;
    }
}

