/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.main.ClientProxy;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class BobMathUtil {
    public static Field r_viewMat;
    public static Random rand;

    public static String getShortNumber(long number) {
        if ((double)number < 1000.0) {
            return "" + number;
        }
        if ((double)number < 1000.0) {
            return String.format("%6.2fk", Float.valueOf((float)number / 1000.0f));
        }
        if ((double)number < 1000000.0) {
            return String.format("%6.2fM", Float.valueOf((float)number / 1000000.0f));
        }
        if ((double)number < 1.0E9) {
            return String.format("%6.2fG", Float.valueOf((float)number / 1.0E9f));
        }
        if ((double)number < 1.0E12) {
            return String.format("%6.2fT", Float.valueOf((float)number / 1.0E12f));
        }
        if ((double)number < 1.0E15) {
            return String.format("%6.2fE", Float.valueOf((float)number / 1.0E15f));
        }
        if ((double)number < 1.0E18) {
            return String.format("%6.2fP", Float.valueOf((float)number / 1.0E18f));
        }
        return "INFINTE";
    }

    public static double getAngleFrom2DVecs(double x1, double z1, double x2, double z2) {
        double upper = x1 * x2 + z1 * z2;
        double lower = Math.sqrt(x1 * x1 + z1 * z1) * Math.sqrt(x2 * x2 + z2 * z2);
        double result = Math.toDegrees(Math.cos(upper / lower));
        if (result >= 180.0) {
            result -= 180.0;
        }
        return result;
    }

    public static double getCrossAngle(Vec3d vel, Vec3d rel) {
        double angle = Math.toDegrees(Math.acos((vel = vel.func_72432_b()).func_72430_b(rel = rel.func_72432_b())));
        if (angle >= 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    public static double getCrossAngle(Vec3 vel, Vec3 rel) {
        double angle = Math.toDegrees(Math.acos((vel = vel.normalize()).dotProduct(rel = rel.normalize())));
        if (angle >= 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    public static float remap(float num, float min1, float max1, float min2, float max2) {
        return (num - min1) / (max1 - min1) * (max2 - min2) + min2;
    }

    public static float remap01(float num, float min1, float max1) {
        return (num - min1) / (max1 - min1);
    }

    public static float remap01_clamp(float num, float min1, float max1) {
        return MathHelper.func_76131_a((float)((num - min1) / (max1 - min1)), (float)0.0f, (float)1.0f);
    }

    public static Vec3d lerp(Vec3d vec0, Vec3d vec1, float interp) {
        return new Vec3d(vec0.field_72450_a + (vec1.field_72450_a - vec0.field_72450_a) * (double)interp, vec0.field_72448_b + (vec1.field_72448_b - vec0.field_72448_b) * (double)interp, vec0.field_72449_c + (vec1.field_72449_c - vec0.field_72449_c) * (double)interp);
    }

    public static Vec3 getEulerAngles(Vec3 vec) {
        double yaw = Math.toDegrees(Math.atan2(vec.xCoord, vec.zCoord));
        double sqrt = MathHelper.func_76133_a((double)(vec.xCoord * vec.xCoord + vec.zCoord * vec.zCoord));
        double pitch = Math.toDegrees(Math.atan2(vec.yCoord, sqrt));
        return Vec3.createVectorHelper(yaw, pitch, 0.0);
    }

    public static Vec3d getEulerAngles(Vec3d vec) {
        double yaw = Math.toDegrees(Math.atan2(vec.field_72450_a, vec.field_72449_c));
        double sqrt = MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c));
        double pitch = Math.toDegrees(Math.atan2(vec.field_72448_b, sqrt));
        return new Vec3d(yaw, pitch - 90.0, 0.0);
    }

    public static Vec3d getVectorFromAngle(float yaw, float pitch) {
        Vec3d vec = new Vec3d(0.0, 1.0, 0.0);
        return vec.func_178789_a((float)Math.toRadians(pitch)).func_178785_b((float)Math.toRadians(yaw));
    }

    public static Vec3d getVectorFromAngle(Vec3d vec) {
        return BobMathUtil.getVectorFromAngle((float)vec.field_72450_a, (float)vec.field_72448_b);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d[] worldFromLocal(Vector4f ... positions) {
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        float partialTicks = MainRegistry.proxy.partialTicks();
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        Matrix4f mv_mat = new Matrix4f();
        mv_mat.load(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        if (r_viewMat == null) {
            r_viewMat = ReflectionHelper.findField(ActiveRenderInfo.class, (String)"MODELVIEW", (String)"field_178812_b");
        }
        try {
            FloatBuffer VIEW_MAT = (FloatBuffer)r_viewMat.get(null);
            VIEW_MAT.rewind();
            Matrix4f v_mat = new Matrix4f();
            v_mat.load(VIEW_MAT);
            VIEW_MAT.rewind();
            v_mat.invert();
            Matrix4f.mul((Matrix4f)v_mat, (Matrix4f)mv_mat, (Matrix4f)mv_mat);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        Vec3d[] retArr = new Vec3d[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            Vector4f pos = new Vector4f(positions[i].x, positions[i].y, positions[i].z, positions[i].w);
            Matrix4f.transform((Matrix4f)mv_mat, (Vector4f)pos, (Vector4f)pos);
            Vec3d entPos = renderView.func_174824_e(partialTicks);
            Vec3d pos2 = new Vec3d((double)pos.x, (double)pos.y, (double)pos.z);
            retArr[i] = pos2.func_178787_e(new Vec3d(entPos.field_72450_a, entPos.field_72448_b - (double)renderView.func_70047_e(), entPos.field_72449_c));
        }
        return retArr;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d[] viewFromLocal(Vector4f ... positions) {
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        Matrix4f mv_mat = new Matrix4f();
        mv_mat.load(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        Vec3d[] retArr = new Vec3d[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            Vec3d pos2;
            Vector4f pos = new Vector4f(positions[i].x, positions[i].y, positions[i].z, positions[i].w);
            Matrix4f.transform((Matrix4f)mv_mat, (Vector4f)pos, (Vector4f)pos);
            retArr[i] = pos2 = new Vec3d((double)pos.x, (double)pos.y, (double)pos.z);
        }
        return retArr;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d[] viewToLocal(Vector4f ... positions) {
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        Matrix4f mv_mat = new Matrix4f();
        mv_mat.load(ClientProxy.AUX_GL_BUFFER);
        mv_mat.invert();
        ClientProxy.AUX_GL_BUFFER.rewind();
        Vec3d[] retArr = new Vec3d[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            Vec3d pos2;
            Vector4f pos = new Vector4f(positions[i].x, positions[i].y, positions[i].z, positions[i].w);
            Matrix4f.transform((Matrix4f)mv_mat, (Vector4f)pos, (Vector4f)pos);
            retArr[i] = pos2 = new Vec3d((double)pos.x, (double)pos.y, (double)pos.z);
        }
        return retArr;
    }

    public static void matrixFromQuat(Matrix3f m, Quat4f q) {
        m.m00 = 1.0f - 2.0f * q.y * q.y - 2.0f * q.z * q.z;
        m.m01 = 2.0f * q.x * q.y - 2.0f * q.z * q.w;
        m.m02 = 2.0f * q.x * q.z + 2.0f * q.y * q.w;
        m.m10 = 2.0f * q.x * q.y + 2.0f * q.z * q.w;
        m.m11 = 1.0f - 2.0f * q.x * q.x - 2.0f * q.z * q.z;
        m.m12 = 2.0f * q.y * q.z - 2.0f * q.x * q.w;
        m.m20 = 2.0f * q.x * q.z - 2.0f * q.y * q.w;
        m.m21 = 2.0f * q.y * q.z + 2.0f * q.x * q.w;
        m.m22 = 1.0f - 2.0f * q.x * q.x - 2.0f * q.y * q.y;
    }

    public static boolean epsilonEquals(float num1, float num2, float eps) {
        float diff = num1 - num2;
        return Math.abs(diff) < eps;
    }

    public static boolean epsilonEquals(double num1, double num2, double eps) {
        double diff = num1 - num2;
        return Math.abs(diff) < eps;
    }

    public static boolean epsilonEquals(Vec3d a, Vec3d b, double eps) {
        double dx = Math.abs(a.field_72450_a - b.field_72450_a);
        double dy = Math.abs(a.field_72448_b - b.field_72448_b);
        double dz = Math.abs(a.field_72449_c - b.field_72449_c);
        return dx < eps && dy < eps && dz < eps;
    }

    public static int absMaxIdx(double ... numbers) {
        int idx = 0;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < numbers.length; ++i) {
            double num = Math.abs(numbers[i]);
            if (!(num > max)) continue;
            idx = i;
            max = num;
        }
        return idx;
    }

    public static Vec3 randVecInCone(Vec3 coneDirection, float angle) {
        return BobMathUtil.randVecInCone(coneDirection, angle, rand);
    }

    public static Vec3 randVecInCone(Vec3 coneDirection, float angle, Random rand) {
        Vec3 up = Vec3.createVectorHelper(0.0, 1.0, 0.0);
        up.rotateAroundX((float)Math.toRadians(rand.nextFloat() * (angle + rand.nextFloat() * angle)));
        up.rotateAroundY((float)Math.toRadians(rand.nextFloat() * 360.0f));
        Vec3 direction = Vec3.createVectorHelper(coneDirection.xCoord, coneDirection.yCoord, coneDirection.zCoord);
        Vec3 angles = BobMathUtil.getEulerAngles(direction);
        Vec3 newDirection = Vec3.createVectorHelper(up.xCoord, up.yCoord, up.zCoord);
        newDirection.rotateAroundX((float)Math.toRadians(angles.yCoord - 90.0));
        newDirection.rotateAroundY((float)Math.toRadians(angles.xCoord));
        return newDirection;
    }

    public static Vec3d randVecInCone(Vec3d coneDirection, float angle) {
        return BobMathUtil.randVecInCone(new Vec3(coneDirection), angle).toVec3d();
    }

    public static Vec3d randVecInCone(Vec3d coneDirection, float angle, Random rand) {
        return BobMathUtil.randVecInCone(new Vec3(coneDirection), angle, rand).toVec3d();
    }

    public static Vec3d mix(Vec3d a, Vec3d b, float amount) {
        return new Vec3d(a.field_72450_a + (b.field_72450_a - a.field_72450_a) * (double)amount, a.field_72448_b + (b.field_72448_b - a.field_72448_b) * (double)amount, a.field_72449_c + (b.field_72449_c - a.field_72449_c) * (double)amount);
    }

    public static Vec3d mat4Transform(Vec3d vec, @Nullable Matrix4f mat) {
        if (mat != null) {
            double x = (double)mat.m00 * vec.field_72450_a + (double)mat.m10 * vec.field_72448_b + (double)mat.m20 * vec.field_72449_c + (double)mat.m30;
            double y = (double)mat.m01 * vec.field_72450_a + (double)mat.m11 * vec.field_72448_b + (double)mat.m21 * vec.field_72449_c + (double)mat.m31;
            double z = (double)mat.m02 * vec.field_72450_a + (double)mat.m12 * vec.field_72448_b + (double)mat.m22 * vec.field_72449_c + (double)mat.m32;
            return new Vec3d(x, y, z);
        }
        return vec;
    }

    public static String toPercentage(float amount, float total) {
        return NumberFormat.getPercentInstance().format(amount / total);
    }

    public static double convertScale(double toScale, double oldMin, double oldMax, double newMin, double newMax) {
        double prevRange = oldMax - oldMin;
        double newRange = newMax - newMin;
        return (toScale - oldMin) * newRange / prevRange + newMin;
    }

    public static String[] ticksToDate(long ticks, int tickHour) {
        int tickDay = 24 * tickHour;
        int tickYear = 365 * tickDay;
        double tickMinute = (double)tickHour / 60.0;
        double tickSecond = (double)tickHour / 3600.0;
        String[] dateOut = new String[5];
        long year = Math.floorDiv(ticks, (long)tickYear);
        int day = (int)Math.floorDiv(ticks - (long)tickYear * year, (long)tickDay);
        int h = (int)Math.floorDiv(ticks - (long)tickYear * year - (long)(tickDay * day), (long)tickHour);
        int min = (int)Math.floor((double)(ticks - (long)tickYear * year - (long)(tickDay * day) - (long)(tickHour * h)) / tickMinute);
        int s = (int)Math.floor(((double)(ticks - (long)tickYear * year - (long)(tickDay * day) - (long)(tickHour * h)) - (double)min * tickMinute) / tickSecond);
        dateOut[0] = String.valueOf(year);
        dateOut[1] = String.valueOf(day);
        dateOut[2] = String.valueOf(h);
        dateOut[3] = String.valueOf(min);
        dateOut[4] = String.valueOf(s);
        return dateOut;
    }

    public static String[] ticksToDate(long ticks) {
        return BobMathUtil.ticksToDate(ticks, 1000);
    }

    public static String toDate(String[] input) {
        if (!input[0].equals("0")) {
            return input[0] + "y " + input[1] + "d " + input[2] + "h " + input[3] + "m " + input[4] + "s";
        }
        if (!input[1].equals("0")) {
            return input[1] + "d " + input[2] + "h " + input[3] + "m " + input[4] + "s";
        }
        if (!input[2].equals("0")) {
            return input[2] + "h " + input[3] + "m " + input[4] + "s";
        }
        if (!input[3].equals("0")) {
            return input[3] + "m " + input[4] + "s";
        }
        return input[4] + "s";
    }

    public static int interpolateColor(int colorA, int colorB, float percentB) {
        float rA = colorA >> 16 & 0xFF;
        float gA = colorA >> 8 & 0xFF;
        float bA = colorA & 0xFF;
        float rB = colorB >> 16 & 0xFF;
        float gB = colorB >> 8 & 0xFF;
        float bB = colorB & 0xFF;
        float r = rA + (rB - rA) * percentB;
        float g = gA + (gB - gA) * percentB;
        float b = bA + (bB - bA) * percentB;
        return ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
    }

    static {
        rand = new Random();
    }
}

