/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.capability.HbmCapability;
import com.hbm.handler.HbmKeybinds;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.lib.ForgeDirection;
import com.hbm.packet.NBTPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.rbmk.IRBMKLoadable;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKCraneConsole
extends TileEntityMachineBase
implements ITickable,
INBTPacketReceiver,
SimpleComponent,
IControllable {
    public int centerX;
    public int centerY;
    public int centerZ;
    public int spanF;
    public int spanB;
    public int spanL;
    public int spanR;
    public int height;
    public boolean setUpCrane = false;
    public double lastTiltFront = 0.0;
    public double lastTiltLeft = 0.0;
    public double tiltFront = 0.0;
    public double tiltLeft = 0.0;
    public double lastPosFront = 0.0;
    public double lastPosLeft = 0.0;
    public double posFront = 0.0;
    public double posLeft = 0.0;
    private boolean goesDown = false;
    public double lastProgress = 1.0;
    public double progress = 1.0;
    private boolean hasLoaded = false;
    public double loadedHeat;
    public double loadedEnrichment;
    private boolean up = false;
    private boolean down = false;
    private boolean left = false;
    private boolean right = false;
    private boolean craneLeft = false;
    private boolean craneRight = false;
    private boolean craneUp = false;
    private boolean craneDown = false;
    private static final double speed = 0.05;
    private static final short coolDown = 20;
    private short ticksSince = 0;

    public TileEntityRBMKCraneConsole() {
        super(1);
    }

    private boolean isCooledDown() {
        if (this.ticksSince < 20) {
            this.ticksSince = (short)(this.ticksSince + 1);
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        this.lastTiltFront = this.tiltFront;
        this.lastTiltLeft = this.tiltLeft;
        if (this.goesDown) {
            if (this.progress > 0.0) {
                this.progress -= 0.04;
            } else {
                this.progress = 0.0;
                this.goesDown = false;
                if (!this.field_145850_b.field_72995_K) {
                    ControlEventSystem.get(this.field_145850_b).broadcastToSubscribed(this, ControlEvent.newEvent("rbmk_crane_load"));
                    if (this.canTargetInteract()) {
                        if (this.inventory.getStackInSlot(0).func_190926_b()) {
                            IRBMKLoadable column = this.getColumnAtPos();
                            this.inventory.setStackInSlot(0, column.provideNext());
                            column.unload();
                        } else {
                            this.getColumnAtPos().load(this.inventory.getStackInSlot(0));
                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        this.func_70296_d();
                    }
                }
            }
        } else if (this.progress != 1.0) {
            this.progress += 0.04;
            if (this.progress > 1.0) {
                this.progress = 1.0;
            }
        }
        if (this.isCooledDown()) {
            if (this.craneUp != this.up || this.craneDown != this.down || this.craneLeft != this.left || this.craneRight != this.right) {
                this.ticksSince = 1;
            } else if (this.craneUp || this.craneDown || this.craneLeft || this.craneRight) {
                this.ticksSince = 1;
            }
            this.craneUp = this.up;
            this.craneDown = this.down;
            this.craneLeft = this.left;
            this.craneRight = this.right;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.craneUp) {
                this.posFront += 0.05;
            }
            if (this.craneDown) {
                this.posFront -= 0.05;
            }
            if (this.craneLeft) {
                this.posLeft += 0.05;
            }
            if (this.craneRight) {
                this.posLeft -= 0.05;
            }
        }
        double xCoord = this.field_174879_c.func_177958_n();
        double yCoord = this.field_174879_c.func_177956_o();
        double zCoord = this.field_174879_c.func_177952_p();
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection side = dir.getRotation(ForgeDirection.UP);
        double minX = xCoord + 0.5 - (double)side.offsetX * 1.5;
        double maxX = xCoord + 0.5 + (double)side.offsetX * 1.5 + (double)(dir.offsetX * 2);
        double minZ = zCoord + 0.5 - (double)side.offsetZ * 1.5;
        double maxZ = zCoord + 0.5 + (double)side.offsetZ * 1.5 + (double)(dir.offsetZ * 2);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(Math.min(minX, maxX), yCoord, Math.min(minZ, maxZ), Math.max(minX, maxX), yCoord + 2.0, Math.max(minZ, maxZ)));
        this.tiltFront = 0.0;
        this.tiltLeft = 0.0;
        if (players.size() > 0 && !this.isCraneLoading()) {
            EntityPlayer player = (EntityPlayer)players.get(0);
            HbmCapability.IHBMData props = HbmCapability.getData((Entity)player);
            this.processInput(props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_UP), props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_DOWN), props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_LEFT), props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_RIGHT));
            if (props.getKeyPressed(HbmKeybinds.EnumKeybind.CRANE_LOAD)) {
                this.goesDown = true;
            }
        } else {
            this.up = false;
            this.down = false;
            this.left = false;
            this.right = false;
        }
        this.posFront = MathHelper.func_151237_a((double)this.posFront, (double)(-this.spanB), (double)this.spanF);
        this.posLeft = MathHelper.func_151237_a((double)this.posLeft, (double)(-this.spanR), (double)this.spanL);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemRBMKRod) {
                this.loadedHeat = ItemRBMKRod.getHullHeat(this.inventory.getStackInSlot(0));
                this.loadedEnrichment = ItemRBMKRod.getEnrichment(this.inventory.getStackInSlot(0));
            } else {
                this.loadedHeat = 20.0;
                this.loadedEnrichment = 20.0;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("crane", this.setUpCrane);
            if (this.setUpCrane) {
                nbt.func_74768_a("centerX", this.centerX);
                nbt.func_74768_a("centerY", this.centerY);
                nbt.func_74768_a("centerZ", this.centerZ);
                nbt.func_74768_a("spanF", this.spanF);
                nbt.func_74768_a("spanB", this.spanB);
                nbt.func_74768_a("spanL", this.spanL);
                nbt.func_74768_a("spanR", this.spanR);
                nbt.func_74768_a("height", this.height);
                nbt.func_74780_a("posFront", this.posFront);
                nbt.func_74780_a("posLeft", this.posLeft);
                nbt.func_74757_a("loaded", this.hasItemLoaded());
                nbt.func_74780_a("loadedHeat", this.loadedHeat);
                nbt.func_74780_a("loadedEnrichment", this.loadedEnrichment);
                nbt.func_74757_a("goesDown", this.goesDown);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new NBTPacket(nbt, this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
        }
    }

    public void processInput(boolean inputUP, boolean inputDOWN, boolean inputLEFT, boolean inputRIGHT) {
        this.up = inputUP;
        this.down = inputDOWN;
        this.left = inputLEFT;
        this.right = inputRIGHT;
        if (this.up == this.down) {
            this.up = false;
            this.down = false;
        } else {
            this.tiltFront = this.up ? 30.0 : -30.0;
        }
        if (this.left == this.right) {
            this.left = false;
            this.right = false;
        } else {
            this.tiltLeft = this.left ? 30.0 : -30.0;
        }
        if (!this.field_145850_b.field_72995_K && (this.up || this.down || this.left || this.right)) {
            ControlEventSystem.get(this.field_145850_b).broadcastToSubscribed(this, ControlEvent.newEvent("rbmk_crane_move").setVar("up", new DataValueFloat(this.up)).setVar("down", new DataValueFloat(this.down)).setVar("left", new DataValueFloat(this.left)).setVar("right", new DataValueFloat(this.right)));
        }
    }

    public boolean hasItemLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            return !this.inventory.getStackInSlot(0).func_190926_b();
        }
        return this.hasLoaded;
    }

    public boolean isCraneLoading() {
        return this.progress != 1.0;
    }

    public boolean isAboveValidTarget() {
        return this.getColumnAtPos() != null;
    }

    public boolean canTargetInteract() {
        IRBMKLoadable column = this.getColumnAtPos();
        if (column == null) {
            return false;
        }
        if (this.hasItemLoaded()) {
            return column.canLoad(this.inventory.getStackInSlot(0));
        }
        return column.canUnload();
    }

    public IRBMKLoadable getColumnAtPos() {
        TileEntityRBMKBase column;
        int[] pos;
        int z;
        int y;
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection left = dir.getRotation(ForgeDirection.DOWN);
        int x = (int)Math.floor((double)this.centerX - (double)dir.offsetX * this.posFront - (double)left.offsetX * this.posLeft + 0.5);
        Block b = this.field_145850_b.func_180495_p(new BlockPos(x, y = this.centerY - 1, z = (int)Math.floor((double)this.centerZ - (double)dir.offsetZ * this.posFront - (double)left.offsetZ * this.posLeft + 0.5))).func_177230_c();
        if (b instanceof RBMKBase && (pos = ((BlockDummyable)b).findCore((IBlockAccess)this.field_145850_b, x, y, z)) != null && (column = (TileEntityRBMKBase)this.field_145850_b.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]))) instanceof IRBMKLoadable) {
            return (IRBMKLoadable)((Object)column);
        }
        return null;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.lastPosFront = this.posFront;
        this.lastPosLeft = this.posLeft;
        this.lastProgress = this.progress;
        this.setUpCrane = nbt.func_74767_n("crane");
        this.centerX = nbt.func_74762_e("centerX");
        this.centerY = nbt.func_74762_e("centerY");
        this.centerZ = nbt.func_74762_e("centerZ");
        this.spanF = nbt.func_74762_e("spanF");
        this.spanB = nbt.func_74762_e("spanB");
        this.spanL = nbt.func_74762_e("spanL");
        this.spanR = nbt.func_74762_e("spanR");
        this.height = nbt.func_74762_e("height");
        this.posFront = nbt.func_74769_h("posFront");
        this.posLeft = nbt.func_74769_h("posLeft");
        this.hasLoaded = nbt.func_74767_n("loaded");
        this.posLeft = nbt.func_74769_h("posLeft");
        this.loadedHeat = nbt.func_74769_h("loadedHeat");
        this.loadedEnrichment = nbt.func_74769_h("loadedEnrichment");
        this.goesDown = nbt.func_74767_n("goesDown");
    }

    public void setTarget(int x, int y, int z) {
        this.centerX = x;
        this.centerY = y + RBMKDials.getColumnHeight(this.field_145850_b) + 1;
        this.centerZ = z;
        this.spanF = 7;
        this.spanB = 7;
        this.spanL = 7;
        this.spanR = 7;
        this.height = 7;
        this.setUpCrane = true;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.setUpCrane = nbt.func_74767_n("crane");
        this.centerX = nbt.func_74762_e("centerX");
        this.centerY = nbt.func_74762_e("centerY");
        this.centerZ = nbt.func_74762_e("centerZ");
        this.spanF = nbt.func_74762_e("spanF");
        this.spanB = nbt.func_74762_e("spanB");
        this.spanL = nbt.func_74762_e("spanL");
        this.spanR = nbt.func_74762_e("spanR");
        this.height = nbt.func_74762_e("height");
        this.posFront = nbt.func_74769_h("posFront");
        this.posLeft = nbt.func_74769_h("posLeft");
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("crane", this.setUpCrane);
        nbt.func_74768_a("centerX", this.centerX);
        nbt.func_74768_a("centerY", this.centerY);
        nbt.func_74768_a("centerZ", this.centerZ);
        nbt.func_74768_a("spanF", this.spanF);
        nbt.func_74768_a("spanB", this.spanB);
        nbt.func_74768_a("spanL", this.spanL);
        nbt.func_74768_a("spanR", this.spanR);
        nbt.func_74768_a("height", this.height);
        nbt.func_74780_a("posFront", this.posFront);
        nbt.func_74780_a("posLeft", this.posLeft);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getName() {
        return "rbmk_crane";
    }

    public String getComponentName() {
        return "rbmk_crane";
    }

    @Callback(doc="moveUp(); move the crane up 1 block")
    public Object[] moveUp(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(true, false, false, false);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveDown(); move the crane down 1 block")
    public Object[] moveDown(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(false, true, false, false);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveLeft(); move the crane left 1 block")
    public Object[] moveLeft(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(false, false, true, false);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveRight(); move the crane right 1 block")
    public Object[] moveRight(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(false, false, false, true);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveUpLeft(); move the crane up and left 1 block")
    public Object[] moveUpLeft(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(true, false, true, false);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveUpRight(); move the crane up and right 1 block")
    public Object[] moveUpRight(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(true, false, false, true);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveDownLeft(); move the crane down and left 1 block")
    public Object[] moveDownLeft(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(false, true, true, false);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="moveDownRight(); move the crane down and right 1 block")
    public Object[] moveDownRight(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.processInput(false, true, false, true);
                return new Object[0];
            }
            return new Object[]{"Crane is loading and cant be moved"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="loadUnload(); starts loading/unloading of items")
    public Object[] loadUnload(Context context, Arguments args) {
        if (this.setUpCrane) {
            if (!this.isCraneLoading()) {
                this.goesDown = true;
                return new Object[]{"Loading initiated"};
            }
            return new Object[]{"Crane is already loading"};
        }
        return new Object[]{"No crane found"};
    }

    @Callback(doc="getPos(); get the (x, y) crane displacements. 0,0 is at center rbmk column and y is to the front and x is to the right")
    public Object[] getPos(Context context, Arguments args) {
        if (this.setUpCrane) {
            return new Object[]{-this.posLeft, this.posFront};
        }
        return new Object[]{"No crane found"};
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        HashMap<String, DataValue> data = new HashMap<String, DataValue>();
        if (this.setUpCrane) {
            data.put("posX", new DataValueFloat((float)(-this.posLeft)));
            data.put("posY", new DataValueFloat((float)this.posFront));
        }
        return data;
    }

    @Override
    public void receiveEvent(BlockPos from, ControlEvent e) {
        switch (e.name) {
            case "rbmk_crane_move": {
                boolean up = e.vars.get("up").getBoolean();
                boolean down = e.vars.get("down").getBoolean();
                boolean left = e.vars.get("left").getBoolean();
                boolean right = e.vars.get("right").getBoolean();
                if (!this.setUpCrane || this.isCraneLoading()) break;
                this.processInput(up, down, left, right);
                break;
            }
            case "rbmk_crane_load": {
                if (!this.setUpCrane || this.isCraneLoading()) break;
                this.goesDown = true;
            }
        }
    }

    @Override
    public List<String> getInEvents() {
        return Arrays.asList("rbmk_crane_move", "rbmk_crane_load");
    }

    @Override
    public List<String> getOutEvents() {
        return Arrays.asList("rbmk_crane_move", "rbmk_crane_load");
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }
}

