/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.MachineConfig;
import com.hbm.entity.particle.EntityGasFX;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.forgefluid.FFUtils;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.oil.TileEntityOilDrillBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineOilWell
extends TileEntityOilDrillBase {
    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.getCustomName() : "container.oilWell";
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public void func_73660_a() {
        int timer = MachineConfig.delayPerOperationDerrick;
        ++this.age;
        ++this.age2;
        if (this.age >= timer) {
            this.age -= timer;
        }
        if (this.age2 >= 20) {
            this.age2 -= 20;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            int tank0Amount = this.tanks[0].getFluidAmount();
            int tank1Amount = this.tanks[1].getFluidAmount();
            if (this.age2 == 9 || this.age2 == 19) {
                this.fillFluidInit(this.tanks[0]);
                this.fillFluidInit(this.tanks[1]);
            }
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 1, 2)) {
                this.needsUpdate = true;
            }
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 3, 4)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, this.getMaxPower());
            if (this.power >= (long)MachineConfig.powerConsumptionPerOperationDerrick && tank0Amount < this.tanks[0].getCapacity() && tank1Amount < this.tanks[1].getCapacity()) {
                if (this.age == timer - 1) {
                    this.warning = 0;
                    for (int i = this.field_174879_c.func_177956_o() - 1; i > this.field_174879_c.func_177956_o() - 1 - 100; --i) {
                        if (i <= 0) {
                            this.warning = 2;
                            break;
                        }
                        Block b = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p())).func_177230_c();
                        if (b == ModBlocks.oil_pipe) continue;
                        if ((b.func_176200_f((IBlockAccess)this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p())) || b.func_149638_a(null) < 100.0f) && b != ModBlocks.ore_oil && b != ModBlocks.ore_oil_empty && b != ModBlocks.ore_bedrock_oil) {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()), ModBlocks.oil_pipe.func_176223_P());
                            if (i != this.field_174879_c.func_177956_o() - 100) break;
                            this.warning = 2;
                            break;
                        }
                        if (this.tanks[0].getFluidAmount() < this.tanks[0].getCapacity() && this.tanks[1].getFluidAmount() < this.tanks[1].getCapacity()) {
                            if (this.succ(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()) == 1) {
                                int oilCollected = MachineConfig.oilPerDepositBlockMinDerrick + (MachineConfig.oilPerDepositBlockMaxExtraDerrick > 0 ? this.field_145850_b.field_73012_v.nextInt(MachineConfig.oilPerDepositBlockMaxExtraDerrick) : 0);
                                int gasCollected = MachineConfig.gasPerDepositBlockMinDerrick + (MachineConfig.gasPerDepositBlockMaxExtraDerrick > 0 ? this.field_145850_b.field_73012_v.nextInt(MachineConfig.gasPerDepositBlockMaxExtraDerrick) : 0);
                                this.tanks[0].fill(new FluidStack(this.tankTypes[0], oilCollected), true);
                                this.tanks[1].fill(new FluidStack(this.tankTypes[1], gasCollected), true);
                                this.needsUpdate = true;
                                ExplosionLarge.spawnOilSpills(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 5.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 3);
                                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187549_bG, SoundCategory.BLOCKS, 2.0f, 0.5f);
                                break;
                            }
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()), ModBlocks.oil_pipe.func_176223_P());
                            break;
                        }
                        this.warning = 1;
                        break;
                    }
                }
                this.power -= (long)MachineConfig.powerConsumptionPerOperationDerrick;
            } else {
                this.warning = 1;
            }
            this.warning2 = 0;
            if (this.tanks[1].getFluidAmount() > 0) {
                if (this.inventory.getStackInSlot(5).func_77973_b() == ModItems.fuse || this.inventory.getStackInSlot(5).func_77973_b() == ModItems.screwdriver) {
                    this.warning2 = 2;
                    this.tanks[1].drain(50, true);
                    this.needsUpdate = true;
                    this.field_145850_b.func_72838_d((Entity)new EntityGasFX(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 6.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 0.0, 0.0, 0.0));
                } else {
                    this.warning2 = 1;
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (tank0Amount != this.tanks[0].getFluidAmount() || tank1Amount != this.tanks[1].getFluidAmount()) {
                this.func_70296_d();
            }
        }
    }

    protected void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), Library.POS_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), Library.NEG_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), Library.POS_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), Library.NEG_Z);
    }

    public void fillFluidInit(FluidTank tank) {
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), 2000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), 2000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), 2000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), 2000) || this.needsUpdate;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            int prevAmount = this.tanks[0].getFluidAmount();
            FluidStack drained = this.tanks[0].drain(resource.amount, doDrain);
            if (this.tanks[0].getFluidAmount() != prevAmount) {
                this.needsUpdate = true;
            }
            return drained;
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            int prevAmount = this.tanks[1].getFluidAmount();
            FluidStack drained = this.tanks[1].drain(resource.amount, doDrain);
            if (this.tanks[1].getFluidAmount() != prevAmount) {
                this.needsUpdate = true;
            }
            return drained;
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[0].getFluidAmount() > 0) {
            int prevAmount = this.tanks[0].getFluidAmount();
            FluidStack drained = this.tanks[0].drain(maxDrain, doDrain);
            if (this.tanks[0].getFluidAmount() != prevAmount) {
                this.needsUpdate = true;
            }
            return drained;
        }
        if (this.tanks[1].getFluidAmount() > 0) {
            int prevAmount = this.tanks[1].getFluidAmount();
            FluidStack drained = this.tanks[1].drain(maxDrain, doDrain);
            if (this.tanks[1].getFluidAmount() != prevAmount) {
                this.needsUpdate = true;
            }
            return drained;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

