/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyGenerator;
import com.google.common.base.Predicate;
import com.hbm.entity.particle.EntityGasFlameFX;
import com.hbm.explosion.ExplosionThermo;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.FluidCombustionRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineGasFlare;
import com.hbm.inventory.gui.GUIMachineGasFlare;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineGasFlare
extends TileEntityMachineBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor,
IGUIProvider,
IControlReceiver {
    public long power;
    public static final long maxPower = 1000000L;
    public Fluid tankType;
    public FluidTank tank;
    public boolean isOn = false;
    public boolean doesBurn = false;
    public int cacheEnergy = 0;
    public boolean needsUpdate = false;
    private final UpgradeManager upgradeManager = new UpgradeManager();

    public TileEntityMachineGasFlare() {
        super(6);
        this.tankType = ModForgeFluids.gas;
        this.tank = new FluidTank(64000);
        this.cacheEnergy = FluidCombustionRecipes.getFlameEnergy(ModForgeFluids.gas);
    }

    @Override
    public String getName() {
        return "container.gasFlare";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.tank.readFromNBT(compound);
        if (compound.func_74764_b("tankType")) {
            this.tankType = FluidRegistry.getFluid((String)compound.func_74779_i("tankType"));
        }
        this.isOn = compound.func_74767_n("isOn");
        this.doesBurn = compound.func_74767_n("doesBurn");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        this.tank.writeToNBT(compound);
        if (this.tankType != null) {
            compound.func_74778_a("tankType", this.tankType.getName());
        }
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74757_a("doesBurn", this.doesBurn);
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), Library.POS_X);
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), Library.NEG_X);
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), Library.POS_Z);
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), Library.NEG_Z);
            long prevPower = this.power;
            int prevAmount = this.tank.getFluidAmount();
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.setupTanks();
            if (this.inputValidForTank(1) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 1, 2)) {
                this.needsUpdate = true;
            }
            int maxVent = 50;
            int maxBurn = 10;
            if (this.isOn && this.tank.getFluidAmount() >= 10) {
                this.upgradeManager.eval((IItemHandler)this.inventory, 4, 5);
                int burn = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 6);
                int yield = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT), 6);
                maxVent += maxVent * burn;
                maxBurn += maxBurn * burn;
                this.cacheEnergy = FluidCombustionRecipes.getFlameEnergy(this.tankType);
                if (this.doesBurn && this.cacheEnergy != 0) {
                    int eject = Math.min(maxBurn, this.tank.getFluidAmount());
                    this.tank.drain(eject, true);
                    this.needsUpdate = true;
                    int powerGen = this.cacheEnergy * eject;
                    powerGen += powerGen * yield / 3;
                    this.power += (long)powerGen;
                    if (this.power > 1000000L) {
                        this.power = 1000000L;
                    }
                    this.field_145850_b.func_72838_d((Entity)new EntityGasFlameFX(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 11.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, 0.0, 0.0, 0.0));
                    ExplosionThermo.setEntitiesOnFire(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 11, this.field_174879_c.func_177952_p(), 5);
                    if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 11), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.flamethrowerShoot, SoundCategory.BLOCKS, 1.5f, 1.0f);
                    }
                } else {
                    this.tank.drain(maxVent, true);
                    this.needsUpdate = true;
                }
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000L);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("doesBurn", this.doesBurn);
            data.func_74778_a("tankType", this.tankType.getName());
            this.networkPack(data, 25);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            if (prevPower != this.power || prevAmount != this.tank.getFluidAmount() || this.needsUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.isOn = nbt.func_74767_n("isOn");
        this.doesBurn = nbt.func_74767_n("doesBurn");
        this.tankType = FluidRegistry.getFluid((String)nbt.func_74779_i("tankType"));
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    void setupTanks() {
        ItemStack slotId;
        Item itemId;
        if (this.inventory.getSlots() < 5) {
            this.inventory = this.getNewInventory(6, 64);
        }
        if ((itemId = (slotId = this.inventory.getStackInSlot(3)).func_77973_b()) == ModItems.forge_fluid_identifier) {
            Fluid fluid = ItemForgeFluidIdentifier.getType(slotId);
            int energy = FluidCombustionRecipes.getFlameEnergy(fluid);
            if (this.tankType != fluid) {
                this.tankType = fluid;
                this.cacheEnergy = energy;
                this.tank.setFluid(null);
                this.needsUpdate = true;
            }
        }
    }

    protected boolean inputValidForTank(int slot) {
        ItemStack slotInput = this.inventory.getStackInSlot(slot);
        if (slotInput != ItemStack.field_190927_a && this.tank != null) {
            return FFUtils.checkRestrictions(slotInput, (Predicate<FluidStack>)((Predicate)this::isValidFluid));
        }
        return false;
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getFluid() == this.tankType;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineGasFlare(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineGasFlare(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_174818_b(this.field_174879_c) <= 256.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("valve")) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (data.func_74764_b("dial")) {
            this.doesBurn = !this.doesBurn;
        }
        this.func_70296_d();
    }
}

