/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.IDrillInteraction;
import api.hbm.block.IMiningDrill;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.gas.BlockGasBase;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.CentrifugeRecipes;
import com.hbm.inventory.CrystallizerRecipes;
import com.hbm.inventory.ShredderRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineMiningLaser
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor,
IMiningDrill {
    public long power;
    public int age = 0;
    public static final long maxPower = 100000000L;
    public static final int consumption = 10000;
    public FluidTank tank;
    public boolean isOn;
    public int targetX;
    public int targetY;
    public int targetZ;
    public int lastTargetX;
    public int lastTargetY;
    public int lastTargetZ;
    public boolean beam;
    boolean lock = false;
    double breakProgress;

    public TileEntityMachineMiningLaser() {
        super(0);
        this.inventory = new ItemStackHandler(30){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineMiningLaser.this.func_70296_d();
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                super.setStackInSlot(slot, stack);
                if (stack != null && slot >= 1 && slot <= 8 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
                    TileEntityMachineMiningLaser.this.field_145850_b.func_184148_a(null, (double)TileEntityMachineMiningLaser.this.field_174879_c.func_177958_n() + 0.5, (double)TileEntityMachineMiningLaser.this.field_174879_c.func_177956_o() + 1.5, (double)TileEntityMachineMiningLaser.this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.upgradePlug, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        };
        this.tank = new FluidTank(64000);
    }

    @Override
    public String getName() {
        return "container.miningLaser";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit();
            }
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 2, 0), ForgeDirection.UP);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 100000000L);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (this.lastTargetX != this.targetX || this.lastTargetY != this.targetY || this.lastTargetZ != this.targetZ) {
                this.breakProgress = 0.0;
            }
            this.lastTargetX = this.targetX;
            this.lastTargetY = this.targetY;
            this.lastTargetZ = this.targetZ;
            double clientBreakProgress = 0.0;
            if (this.isOn) {
                int cycles = this.getOverdrive();
                int speed = this.getSpeed();
                int range = this.getRange();
                int fortune = this.getFortune();
                int consumption = this.getConsumption() * speed;
                if (this.doesScream()) {
                    cycles *= 4;
                    speed *= 4;
                    consumption *= 20;
                }
                for (int i = 0; i < cycles; ++i) {
                    if (this.power < (long)consumption) {
                        this.beam = false;
                        break;
                    }
                    this.power -= (long)consumption;
                    if (this.targetY <= 0) {
                        this.targetY = this.field_174879_c.func_177956_o() - 2;
                    }
                    this.scan(range);
                    IBlockState block = this.field_145850_b.func_180495_p(new BlockPos(this.targetX, this.targetY, this.targetZ));
                    if (block.func_185904_a().func_76224_d()) {
                        this.field_145850_b.func_175698_g(new BlockPos(this.targetX, this.targetY, this.targetZ));
                        this.buildDam();
                        continue;
                    }
                    if (!this.beam || !this.canBreak(block, this.targetX, this.targetY, this.targetZ)) continue;
                    this.breakProgress += this.getBreakSpeed(speed);
                    clientBreakProgress = Math.min(this.breakProgress, 1.0);
                    if (this.breakProgress < 1.0) {
                        this.field_145850_b.func_175715_c(-1, new BlockPos(this.targetX, this.targetY, this.targetZ), (int)Math.floor(this.breakProgress * 10.0));
                        continue;
                    }
                    this.breakBlock(fortune);
                    this.buildDam();
                }
                if (this.doesScream()) {
                    this.field_145850_b.func_184148_a(null, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, HBMSoundHandler.screm, SoundCategory.BLOCKS, 20.0f, 1.0f);
                }
            } else {
                this.targetY = this.field_174879_c.func_177956_o() - 2;
                this.beam = false;
            }
            this.tryFillContainer(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.tryFillContainer(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.tryFillContainer(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2);
            this.tryFillContainer(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2);
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("lastX", this.lastTargetX);
            data.func_74768_a("lastY", this.lastTargetY);
            data.func_74768_a("lastZ", this.lastTargetZ);
            data.func_74768_a("x", this.targetX);
            data.func_74768_a("y", this.targetY);
            data.func_74768_a("z", this.targetZ);
            data.func_74757_a("beam", this.beam);
            data.func_74757_a("isOn", this.isOn);
            data.func_74780_a("progress", clientBreakProgress);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.lastTargetX = data.func_74762_e("lastX");
        this.lastTargetY = data.func_74762_e("lastY");
        this.lastTargetZ = data.func_74762_e("lastZ");
        this.targetX = data.func_74762_e("x");
        this.targetY = data.func_74762_e("y");
        this.targetZ = data.func_74762_e("z");
        this.beam = data.func_74767_n("beam");
        this.isOn = data.func_74767_n("isOn");
        this.breakProgress = data.func_74769_h("progress");
    }

    private void buildDam() {
        this.placeBags(new BlockPos(this.targetX + 1, this.targetY, this.targetZ));
        this.placeBags(new BlockPos(this.targetX - 1, this.targetY, this.targetZ));
        this.placeBags(new BlockPos(this.targetX, this.targetY, this.targetZ + 1));
        this.placeBags(new BlockPos(this.targetX, this.targetY, this.targetZ - 1));
    }

    private void placeBags(BlockPos wallPos) {
        IBlockState bState = this.field_145850_b.func_180495_p(wallPos);
        if (bState.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, wallPos) && bState.func_185904_a().func_76224_d()) {
            this.field_145850_b.func_175656_a(wallPos, ModBlocks.barricade.func_176223_P());
        }
    }

    private void tryFillContainer(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
        if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return;
        }
        IItemHandler h = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(h instanceof IItemHandlerModifiable)) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)h;
        for (int i = 9; i <= 29; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            int prev = this.inventory.getStackInSlot(i).func_190916_E();
            this.inventory.setStackInSlot(i, InventoryUtil.tryAddItemToInventory(inv, 0, inv.getSlots() - 1, this.inventory.getStackInSlot(i)));
            if (!this.inventory.getStackInSlot(i).func_190926_b() && this.inventory.getStackInSlot(i).func_190916_E() >= prev) continue;
            return;
        }
    }

    private void breakBlock(int fortune) {
        ItemStack drop;
        IDrillInteraction in;
        ItemStack stack;
        IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(this.targetX, this.targetY, this.targetZ));
        Block b = state.func_177230_c();
        boolean normal = true;
        boolean doesBreak = true;
        if (b == Blocks.field_150439_ay) {
            b = Blocks.field_150450_ax;
            state = Blocks.field_150450_ax.func_176223_P();
        }
        if ((stack = new ItemStack(b, 1, b.func_176201_c(state))) != null && stack.func_77973_b() != null) {
            ItemStack result;
            if (this.hasCrystallizer()) {
                result = CrystallizerRecipes.getOutputItem(stack);
                if (result != null && result.func_77973_b() != ModItems.scrap) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, result.func_77946_l()));
                    normal = false;
                }
            } else if (this.hasCentrifuge()) {
                result = CentrifugeRecipes.getOutput(stack);
                if (result != null) {
                    for (ItemStack sta : result) {
                        if (sta == null) continue;
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, sta.func_77946_l()));
                        normal = false;
                    }
                }
            } else if (this.hasShredder()) {
                result = ShredderRecipes.getShredderResult(stack);
                if (result != null && result.func_77973_b() != ModItems.scrap) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, result.func_77946_l()));
                    normal = false;
                }
            } else if (this.hasSmelter() && (result = FurnaceRecipes.func_77602_a().func_151395_a(stack)) != null) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, result.func_77946_l()));
                normal = false;
            }
        }
        if (normal && b instanceof IDrillInteraction && (doesBreak = (in = (IDrillInteraction)b).canBreak(this.field_145850_b, this.targetX, this.targetY, this.targetZ, state, this)) && (drop = in.extractResource(this.field_145850_b, this.targetX, this.targetY, this.targetZ, state, this)) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, drop.func_77946_l()));
        }
        if (doesBreak) {
            if (normal) {
                b.func_176226_b(this.field_145850_b, new BlockPos(this.targetX, this.targetY, this.targetZ), state, fortune);
            }
            this.field_145850_b.func_175655_b(new BlockPos(this.targetX, this.targetY, this.targetZ), false);
        }
        this.suckDrops();
        this.breakProgress = 0.0;
    }

    private void suckDrops() {
        int rangeHor = 3;
        boolean rangeVer = true;
        boolean nullifier = this.hasNullifier();
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.targetX + 0.5 - (double)rangeHor, (double)this.targetY + 0.5 - (double)rangeVer, (double)this.targetZ + 0.5 - (double)rangeHor, (double)this.targetX + 0.5 + (double)rangeHor, (double)this.targetY + 0.5 + (double)rangeVer, (double)this.targetZ + 0.5 + (double)rangeHor));
        for (EntityItem item : items) {
            if (nullifier && ItemMachineUpgrade.scrapItems.contains(item.func_92059_d().func_77973_b())) {
                item.func_70106_y();
                continue;
            }
            if (item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)ModBlocks.ore_oil)) {
                this.tank.fill(new FluidStack(ModForgeFluids.oil, 500), true);
                item.func_70106_y();
                continue;
            }
            ItemStack stack = InventoryUtil.tryAddItemToInventory((IItemHandlerModifiable)this.inventory, 9, 29, item.func_92059_d().func_77946_l());
            if (stack == null) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(stack.func_77946_l());
        }
        List mobs = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.targetX + 0.5 - 1.0, (double)this.targetY + 0.5 - 1.0, (double)this.targetZ + 0.5 - 1.0, (double)this.targetX + 0.5 + 1.0, (double)this.targetY + 0.5 + 1.0, (double)this.targetZ + 0.5 + 1.0));
        for (EntityLivingBase mob : mobs) {
            mob.func_70015_d(5);
        }
    }

    public double getBreakSpeed(int speed) {
        float hardness = this.field_145850_b.func_180495_p(new BlockPos(this.targetX, this.targetY, this.targetZ)).func_185887_b(this.field_145850_b, new BlockPos(this.targetX, this.targetY, this.targetZ)) * 15.0f / (float)speed;
        if (hardness == 0.0f) {
            return 1.0;
        }
        return 1.0f / hardness;
    }

    public void scan(int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (this.field_145850_b.func_180495_p(new BlockPos(x + this.field_174879_c.func_177958_n(), this.targetY, z + this.field_174879_c.func_177952_p())).func_185904_a().func_76224_d() || !this.canBreak(this.field_145850_b.func_180495_p(new BlockPos(x + this.field_174879_c.func_177958_n(), this.targetY, z + this.field_174879_c.func_177952_p())), x + this.field_174879_c.func_177958_n(), this.targetY, z + this.field_174879_c.func_177952_p())) continue;
                this.targetX = x + this.field_174879_c.func_177958_n();
                this.targetZ = z + this.field_174879_c.func_177952_p();
                this.beam = true;
                return;
            }
        }
        this.beam = false;
        --this.targetY;
    }

    private boolean canBreak(IBlockState block, int x, int y, int z) {
        Block b = block.func_177230_c();
        if (b == Blocks.field_150350_a) {
            return false;
        }
        if (b == Blocks.field_150357_h) {
            return false;
        }
        if (b instanceof BlockGasBase) {
            return false;
        }
        float hardness = block.func_185887_b(this.field_145850_b, new BlockPos(x, y, z));
        if (hardness < 0.0f || hardness > 3500000.0f) {
            return false;
        }
        return !block.func_185904_a().func_76224_d();
    }

    public int getOverdrive() {
        int speed = 1;
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_overdrive_1) {
                ++speed;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_overdrive_2) {
                speed += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_overdrive_3) continue;
            speed += 3;
        }
        return Math.min(speed, 4);
    }

    public int getSpeed() {
        int speed = 1;
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_1) {
                speed += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_2) {
                speed += 4;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_speed_3) continue;
            speed += 6;
        }
        return Math.min(speed, 13);
    }

    public int getRange() {
        int range = 1;
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_1) {
                range += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_2) {
                range += 4;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_effect_3) continue;
            range += 6;
        }
        return Math.min(range, 25);
    }

    public int getFortune() {
        int fortune = 0;
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_fortune_1) {
                ++fortune;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_fortune_2) {
                fortune += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_fortune_3) continue;
            fortune += 3;
        }
        return Math.min(fortune, 3);
    }

    public boolean hasNullifier() {
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_nullifier) continue;
            return true;
        }
        return false;
    }

    public boolean hasSmelter() {
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_smelter) continue;
            return true;
        }
        return false;
    }

    public boolean hasShredder() {
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_shredder) continue;
            return true;
        }
        return false;
    }

    public boolean hasCentrifuge() {
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_centrifuge) continue;
            return true;
        }
        return false;
    }

    public boolean hasCrystallizer() {
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_crystallizer) continue;
            return true;
        }
        return false;
    }

    public boolean doesScream() {
        for (int i = 1; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_screm) continue;
            return true;
        }
        return false;
    }

    public int getConsumption() {
        int consumption = 10000;
        return consumption;
    }

    public int getWidth() {
        return 1 + this.getRange() * 2;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public int getPowerScaled(int i) {
        return (int)(this.power * (long)i / 100000000L);
    }

    public int getProgressScaled(int i) {
        return (int)(this.breakProgress * (double)i);
    }

    @Override
    public boolean canInsertItem(int i, ItemStack itemStack, int j) {
        return this.isItemValidForSlot(i, itemStack);
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i >= 9 && i <= 29;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing slot) {
        int[] slots = new int[21];
        for (int i = 0; i < 21; ++i) {
            slots[i] = i + 9;
        }
        return slots;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    public void fillFluidInit() {
        this.fillFluid(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.tank);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, this.tank);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, this.tank);
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), 5000);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == ModForgeFluids.oil) {
            return this.tank.drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.isOn = compound.func_74767_n("isOn");
        this.power = compound.func_74763_f("power");
        this.targetX = compound.func_74762_e("x");
        this.targetY = compound.func_74762_e("y");
        this.targetZ = compound.func_74762_e("z");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("x", this.targetX);
        compound.func_74768_a("y", this.targetY);
        compound.func_74768_a("z", this.targetZ);
        return super.func_189515_b(compound);
    }

    @Override
    public IMiningDrill.DrillType getDrillTier() {
        return IMiningDrill.DrillType.HITECH;
    }

    @Override
    public int getDrillRating() {
        return 100;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

