/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyGenerator;
import com.google.common.base.Predicate;
import com.hbm.blocks.machine.MachineGenerator;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFuelRod;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineGenerator
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory;
    public int heat;
    public final int heatMax = 100000;
    public long power;
    public final long maxPower = 100000L;
    public boolean isLoaded = false;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public boolean needsUpdate;
    private String customName;
    private long detectPower;
    private int detectHeat;
    private FluidTank[] detectTanks = new FluidTank[]{null, null};

    public TileEntityMachineGenerator() {
        this.inventory = new ItemStackHandler(14){

            protected void onContentsChanged(int slot) {
                TileEntityMachineGenerator.this.func_70296_d();
                super.onContentsChanged(slot);
            }

            public boolean isItemValid(int i, ItemStack itemStack) {
                if (i >= 0 && i <= 8 && itemStack.func_77973_b() instanceof ItemFuelRod) {
                    return true;
                }
                if (i == 9 && FFUtils.containsFluid(itemStack, FluidRegistry.WATER)) {
                    return true;
                }
                if (i == 10 && FFUtils.containsFluid(itemStack, ModForgeFluids.coolant)) {
                    return true;
                }
                return i == 11 && itemStack.func_77973_b() instanceof IBatteryItem;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (this.isItemValid(slot, stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return ItemStack.field_190927_a;
            }
        };
        this.tanks = new FluidTank[2];
        this.tankTypes = new Fluid[2];
        this.tanks[0] = new FluidTank(32000);
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tanks[1] = new FluidTank(16000);
        this.tankTypes[1] = ModForgeFluids.coolant;
        this.needsUpdate = false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
                this.needsUpdate = false;
            }
            this.sendPower(this.field_145850_b, this.field_174879_c);
            if (this.inputValidForTank(0, 9)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 9, 12);
            }
            if (this.inputValidForTank(1, 10)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 10, 13);
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 11, this.power, 100000L);
            for (int i = 0; i < 9; ++i) {
                int j;
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_uranium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(100);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_uranium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_dual_uranium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(100);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_dual_uranium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_quad_uranium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(100);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_quad_uranium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_plutonium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(2);
                    this.attemptPower(150);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_plutonium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_dual_plutonium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(2);
                    this.attemptPower(150);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_dual_plutonium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_quad_plutonium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(2);
                    this.attemptPower(150);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_quad_plutonium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_mox_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(50);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_mox_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_dual_mox_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(50);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_dual_mox_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_quad_mox_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(50);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_quad_mox_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_schrabidium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(10);
                    this.attemptPower(25000);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_schrabidium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && this.inventory.getStackInSlot(i).func_77973_b() == ModItems.rod_dual_schrabidium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                    ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                    this.attemptHeat(10);
                    this.attemptPower(25000);
                    if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) == ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) {
                        this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_dual_schrabidium_fuel_depleted));
                    }
                }
                if (this.inventory.getStackInSlot(i) == ItemStack.field_190927_a || this.inventory.getStackInSlot(i).func_77973_b() != ModItems.rod_quad_schrabidium_fuel) continue;
                j = ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
                ItemFuelRod.setLifetime(this.inventory.getStackInSlot(i), j + 1);
                this.attemptHeat(10);
                this.attemptPower(25000);
                if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i)) != ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime()) continue;
                this.inventory.setStackInSlot(i, new ItemStack(ModItems.rod_quad_schrabidium_fuel_depleted));
            }
            if (this.power > 100000L) {
                this.power = 100000L;
            }
            if (this.heat > 100000) {
                this.explode();
            }
            if (!((this.inventory.getStackInSlot(0) == ItemStack.field_190927_a || !(this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemFuelRod)) && this.inventory.getStackInSlot(0) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(1) == ItemStack.field_190927_a || this.inventory.getStackInSlot(1).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(1) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(2) == ItemStack.field_190927_a || this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(2) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(3) == ItemStack.field_190927_a || this.inventory.getStackInSlot(3).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(3) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(4) == ItemStack.field_190927_a || this.inventory.getStackInSlot(4).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(4) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(5) == ItemStack.field_190927_a || this.inventory.getStackInSlot(5).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(5) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(6) == ItemStack.field_190927_a || this.inventory.getStackInSlot(6).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(6) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(7) == ItemStack.field_190927_a || this.inventory.getStackInSlot(7).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(7) != ItemStack.field_190927_a || (this.inventory.getStackInSlot(8) == ItemStack.field_190927_a || this.inventory.getStackInSlot(8).func_77973_b() instanceof ItemFuelRod) && this.inventory.getStackInSlot(8) != ItemStack.field_190927_a)) {
                if (this.heat - 10 >= 0 && this.tanks[1].getFluidAmount() - 2 >= 0) {
                    this.heat -= 10;
                    this.tanks[1].drain(2, true);
                }
                if (this.heat < 10 && this.heat != 0 && this.tanks[1].getFluidAmount() != 0) {
                    --this.heat;
                    this.tanks[1].drain(1, true);
                }
                if (this.heat != 0 && this.tanks[1].getFluidAmount() == 0) {
                    --this.heat;
                }
                if (this.field_145850_b.func_180495_p(this.field_174879_c) instanceof MachineGenerator) {
                    this.isLoaded = false;
                }
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c) instanceof MachineGenerator) {
                this.isLoaded = true;
            }
            this.detectAndSendChanges();
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (this.inventory.getStackInSlot(slot) != ItemStack.field_190927_a && this.tanks[tank] != null) {
            return FFUtils.checkRestrictions(this.inventory.getStackInSlot(slot), (Predicate<FluidStack>)((Predicate)f -> f.getFluid() == this.tankTypes[tank]));
        }
        return false;
    }

    public void attemptPower(int i) {
        int j = (int)Math.ceil(i / 100);
        if (this.tanks[0].getFluidAmount() - j >= 0) {
            this.power += (long)i;
            if (j > this.tanks[0].getCapacity() / 25) {
                j = this.tanks[0].getCapacity() / 25;
            }
            this.tanks[0].drain(j, true);
        }
    }

    public void attemptHeat(int i) {
        Random rand = new Random();
        int j = rand.nextInt(i + 1);
        if (this.tanks[1].getFluidAmount() - j >= 0) {
            this.tanks[1].drain(j, true);
        } else {
            this.heat += i;
        }
    }

    public void explode() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 18.0f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 35);
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150356_k.func_176223_P());
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tankTypes[1] = ModForgeFluids.coolant;
        this.power = compound.func_74763_f("power");
        this.detectPower = this.power + 1L;
        this.heat = compound.func_74762_e("heat");
        this.detectHeat = this.heat + 1;
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("heat", this.heat);
        NBTTagCompound tag = this.inventory.serializeNBT();
        compound.func_74782_a("inventory", (NBTBase)tag);
        NBTTagList tankTag = FFUtils.serializeTankArray(this.tanks);
        compound.func_74782_a("tanks", (NBTBase)tankTag);
        return super.func_189515_b(compound);
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.generator";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 100000;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean hasHeat() {
        return this.heat > 0;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == FluidRegistry.WATER) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == ModForgeFluids.coolant) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing)));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        }
        if (this.detectHeat != this.heat) {
            mark = true;
            this.detectHeat = this.heat;
        }
        if (!FFUtils.areTanksEqual(this.tanks[0], this.detectTanks[0])) {
            mark = true;
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
            this.needsUpdate = true;
        }
        if (!FFUtils.areTanksEqual(this.tanks[1], this.detectTanks[1])) {
            mark = true;
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
            this.needsUpdate = true;
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }
}

