/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.MachineRecipes;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineGasCent
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
ITankPacketAcceptor,
IFluidHandler {
    public long power;
    public int progress;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 200;
    public boolean needsUpdate = false;
    public FluidTank tank = new FluidTank(8000);
    private String customName;
    private long detectPower;
    private int detectProgress;
    private boolean detectIsProgressing;
    private FluidTank detectTank;

    public TileEntityMachineGasCent() {
        super(9);
    }

    @Override
    public String getName() {
        return "container.gasCentrifuge";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("powerTime");
        this.progress = nbt.func_74765_d("CookTime");
        this.tank.readFromNBT(nbt);
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74777_a("cookTime", (short)this.progress);
        this.tank.writeToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / 200;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    private boolean canProcess() {
        if (this.power > 0L && this.tank.getFluidAmount() >= MachineRecipes.getFluidConsumedGasCent(this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid())) {
            List<MachineRecipes.GasCentOutput> list = MachineRecipes.getGasCentOutput(this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid());
            if (list == null) {
                return false;
            }
            if (list.size() < 1 || list.size() > 4) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                int slot = i + 5;
                if (this.inventory.getStackInSlot(slot).func_190926_b() || this.inventory.getStackInSlot(slot).func_77973_b() == list.get((int)i).output.func_77973_b() && this.inventory.getStackInSlot(slot).func_77952_i() == list.get((int)i).output.func_77952_i() && this.inventory.getStackInSlot(slot).func_190916_E() + list.get((int)i).output.func_190916_E() <= this.inventory.getStackInSlot(slot).func_77976_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void process() {
        List<MachineRecipes.GasCentOutput> out = MachineRecipes.getGasCentOutput(this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid());
        this.progress = 0;
        this.tank.drain(MachineRecipes.getFluidConsumedGasCent(this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid()), true);
        ArrayList<MachineRecipes.GasCentOutput> random = new ArrayList<MachineRecipes.GasCentOutput>();
        for (int i = 0; i < out.size(); ++i) {
            for (int j = 0; j < out.get((int)i).weight; ++j) {
                random.add(out.get(i));
            }
        }
        Collections.shuffle(random);
        MachineRecipes.GasCentOutput result = (MachineRecipes.GasCentOutput)random.get(this.field_145850_b.field_73012_v.nextInt(random.size()));
        int slot = result.slot + 4;
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            this.inventory.setStackInSlot(slot, result.output.func_77946_l());
        } else {
            this.inventory.getStackInSlot(slot).func_190917_f(result.output.func_190916_E());
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.updateConnectionsExcept(this.field_145850_b, this.field_174879_c, Library.POS_Y);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tank}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 100000L);
            if (this.inputValidForTank(-1, 3)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 3, 4);
            }
            if (this.canProcess()) {
                this.isProgressing = true;
                ++this.progress;
                this.power -= 200L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
                if (this.progress >= 200) {
                    this.process();
                }
            } else {
                this.isProgressing = false;
                this.progress = 0;
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            this.detectAndSendChanges();
        }
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            this.detectPower = this.power;
            mark = true;
        }
        if (this.detectProgress != this.progress) {
            this.detectProgress = this.progress;
            mark = true;
        }
        if (this.detectIsProgressing != this.isProgressing) {
            this.detectIsProgressing = this.isProgressing;
            mark = true;
        }
        if (!FFUtils.areTanksEqual(this.tank, this.detectTank)) {
            this.detectTank = FFUtils.copyTank(this.tank);
            this.needsUpdate = true;
            mark = true;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.progress, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.isProgressing ? 1 : 0, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return !this.inventory.getStackInSlot(slot).func_190926_b() && this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return MachineRecipes.getFluidConsumedGasCent(stack.getFluid()) != 0;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot > 3;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 3, 4, 5, 6, 7, 8};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 4, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

