/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineCMBFactory
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power = 0L;
    public int process = 0;
    public int soundCycle = 0;
    public static final long maxPower = 100000000L;
    public static final int processSpeed = 200;
    public FluidTank tank;
    public Fluid tankType = ModForgeFluids.watz;
    public boolean needsUpdate = false;
    private static final int[] slots_top = new int[]{1, 3};
    private static final int[] slots_bottom = new int[]{0, 2, 4};
    private static final int[] slots_side = new int[]{0, 2};

    public TileEntityMachineCMBFactory() {
        super(6);
        this.tank = new FluidTank(8000);
    }

    @Override
    public String getName() {
        return "container.machineCMB";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, int amount) {
        return this.isItemValidForSlot(slot, stack);
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int amount) {
        if (i == 4) {
            return true;
        }
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
            return true;
        }
        return i == 2 && FFUtils.containsFluid(itemStack, ModForgeFluids.watz);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
            case 1: {
                if (stack.func_77973_b() != ModItems.ingot_magnetized_tungsten && stack.func_77973_b() != ModItems.powder_magnetized_tungsten) break;
                return true;
            }
            case 2: {
                if (!FFUtils.containsFluid(stack, ModForgeFluids.watz)) break;
                return true;
            }
            case 3: {
                if (stack.func_77973_b() != ModItems.ingot_advanced_alloy && stack.func_77973_b() != ModItems.powder_advanced_alloy) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.tank.readFromNBT(compound);
        this.process = compound.func_74765_d("process");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        this.tank.writeToNBT(compound);
        compound.func_74777_a("process", (short)this.process);
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000000L;
    }

    public int getProgressScaled(int i) {
        return this.process * i / 200;
    }

    public boolean canProcess() {
        boolean b = false;
        if (!(this.tank.getFluidAmount() < 1 || this.power < 100000L || this.inventory.getStackInSlot(1).func_190926_b() || this.inventory.getStackInSlot(3).func_190926_b() || !this.inventory.getStackInSlot(4).func_190926_b() && this.inventory.getStackInSlot(4).func_190916_E() > 60)) {
            boolean flag0 = this.inventory.getStackInSlot(1).func_77973_b() == ModItems.ingot_magnetized_tungsten || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.powder_magnetized_tungsten;
            boolean flag1 = this.inventory.getStackInSlot(3).func_77973_b() == ModItems.ingot_advanced_alloy || this.inventory.getStackInSlot(3).func_77973_b() == ModItems.powder_advanced_alloy;
            b = flag0 && flag1;
        }
        return b;
    }

    public boolean isProcessing() {
        return this.process > 0;
    }

    public void process() {
        this.tank.drain(1, true);
        this.needsUpdate = true;
        this.power -= 100000L;
        ++this.process;
        if (this.process >= 200) {
            this.inventory.getStackInSlot(1).func_190918_g(1);
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            }
            this.inventory.getStackInSlot(3).func_190918_g(1);
            if (this.inventory.getStackInSlot(3).func_190926_b()) {
                this.inventory.setStackInSlot(3, ItemStack.field_190927_a);
            }
            if (this.inventory.getStackInSlot(4).func_190926_b()) {
                this.inventory.setStackInSlot(4, new ItemStack(ModItems.ingot_combine_steel, 4));
            } else {
                this.inventory.getStackInSlot(4).func_190917_f(4);
            }
            this.process = 0;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            long prevPower = this.power;
            int prevAmount = this.tank.getFluidAmount();
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 100000000L);
            if (this.inputValidForTank(-1, 2) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 2, 5)) {
                this.needsUpdate = true;
            }
            if (this.canProcess()) {
                this.process();
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f, 1.5f);
                }
                ++this.soundCycle;
                if (this.soundCycle >= 25) {
                    this.soundCycle = 0;
                }
            } else {
                this.process = 0;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (prevPower != this.power || prevAmount != this.tank.getFluidAmount()) {
                this.func_70296_d();
            }
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return !this.inventory.getStackInSlot(slot).func_190926_b() && this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getFluid() == ModForgeFluids.watz;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            if (this.tank.fill(resource, false) > 0) {
                this.needsUpdate = true;
            }
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

