/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.tile.IHeatSource;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHeaterElectric
extends TileEntityLoadedBase
implements IHeatSource,
IEnergyUser,
ITickable,
INBTPacketReceiver {
    public long power;
    public int heatEnergy;
    public boolean isOn;
    protected int setting = 1;
    AxisAlignedBB bb = null;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
                this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 3, 0, dir.offsetZ * 3), dir);
            }
            this.heatEnergy = (int)((double)this.heatEnergy * 0.999);
            this.tryPullHeat();
            this.isOn = false;
            if (this.setting > 0 && this.power >= this.getConsumption()) {
                this.power -= this.getConsumption();
                this.heatEnergy += this.getHeatGen();
                this.isOn = true;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("s", (byte)this.setting);
            data.func_74768_a("h", this.heatEnergy);
            data.func_74757_a("o", this.isOn);
            INBTPacketReceiver.networkPack(this, data, 25);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.setting = nbt.func_74771_c("s");
        this.heatEnergy = nbt.func_74762_e("h");
        this.isOn = nbt.func_74767_n("o");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.setting = nbt.func_74762_e("setting");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("setting", this.setting);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        return nbt;
    }

    protected void tryPullHeat() {
        TileEntity con = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            this.heatEnergy = (int)((double)this.heatEnergy + (double)source.getHeatStored() * 0.85);
            source.useUpHeat(source.getHeatStored());
        }
    }

    public void toggleSettingUp() {
        ++this.setting;
        if (this.setting > 10) {
            this.setting = 0;
        }
    }

    public void toggleSettingDown() {
        --this.setting;
        if (this.setting < 0) {
            this.setting = 10;
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public long getConsumption() {
        return (long)(Math.pow(this.setting, 1.4) * 200.0);
    }

    @Override
    public long getMaxPower() {
        return this.getConsumption() * 20L;
    }

    public int getHeatGen() {
        return this.setting * 100;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

