/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockHadronCoil;
import com.hbm.blocks.machine.BlockHadronPlating;
import com.hbm.inventory.HadronRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.main.AdvancementManager;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityHadronDiode;
import com.hbm.tileentity.machine.TileEntityHadronPower;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityHadron
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public static final long maxPower = 10000000L;
    public boolean isOn = false;
    public boolean analysisOnly = false;
    public boolean hopperMode = false;
    private int delay;
    public EnumHadronState state = EnumHadronState.IDLE;
    private static final int delaySuccess = 20;
    private static final int delayNoResult = 60;
    private static final int delayError = 100;
    public boolean stat_success = false;
    public EnumHadronState stat_state = EnumHadronState.IDLE;
    public int stat_charge = 0;
    public int stat_x = 0;
    public int stat_y = 0;
    public int stat_z = 0;
    private static final int[] access = new int[]{0, 1, 2, 3};
    static final int maxParticles = 1;
    List<Particle> particles = new ArrayList<Particle>();
    List<Particle> particlesToRemove = new ArrayList<Particle>();

    public TileEntityHadron() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.hadron";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return access;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 2 || slot == 3;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return i == 0 || i == 1;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 4, this.power, 10000000L);
            this.drawPower();
            if (this.delay <= 0 && this.isOn && this.particles.size() < 1 && !this.inventory.getStackInSlot(0).func_190926_b() && !this.inventory.getStackInSlot(1).func_190926_b() && (double)this.power >= 7500000.0 && (!this.hopperMode || this.inventory.getStackInSlot(0).func_190916_E() > 1 && this.inventory.getStackInSlot(1).func_190916_E() > 1)) {
                Object dir = ForgeDirection.getOrientation(this.func_145832_p());
                this.particles.add(new Particle(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), (ForgeDirection)((Object)dir), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                this.inventory.getStackInSlot(0).func_190918_g(1);
                this.inventory.getStackInSlot(1).func_190918_g(1);
                this.power = (long)((double)this.power - 7500000.0);
                this.state = EnumHadronState.PROGRESS;
            }
            if (this.delay > 0) {
                --this.delay;
            } else if (this.particles.isEmpty()) {
                this.state = EnumHadronState.IDLE;
            }
            if (!this.particles.isEmpty()) {
                this.updateParticles();
            }
            for (Particle p : this.particlesToRemove) {
                this.particles.remove(p);
            }
            this.particlesToRemove.clear();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isOn", this.isOn);
            data.func_74772_a("power", this.power);
            data.func_74757_a("analysis", this.analysisOnly);
            data.func_74757_a("hopperMode", this.hopperMode);
            data.func_74774_a("state", (byte)this.state.ordinal());
            data.func_74757_a("stat_success", this.stat_success);
            data.func_74774_a("stat_state", (byte)this.stat_state.ordinal());
            data.func_74768_a("stat_charge", this.stat_charge);
            data.func_74768_a("stat_x", this.stat_x);
            data.func_74768_a("stat_y", this.stat_y);
            data.func_74768_a("stat_z", this.stat_z);
            this.networkPack(data, 50);
        }
    }

    private void process(Particle p) {
        ItemStack[] result = HadronRecipes.getOutput(p.item1, p.item2, p.momentum, this.analysisOnly);
        if (result == null) {
            this.state = HadronRecipes.returnCode;
            this.setStats(this.state, p.momentum, false);
            this.delay = 60;
            this.field_145850_b.func_184148_a(null, (double)p.posX, (double)p.posY, (double)p.posZ, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 2.0f, 0.5f);
            return;
        }
        if ((this.inventory.getStackInSlot(2).func_190926_b() || this.inventory.getStackInSlot(2).func_77973_b() == result[0].func_77973_b() && this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getStackInSlot(2).func_77976_d()) && (this.inventory.getStackInSlot(3).func_190926_b() || this.inventory.getStackInSlot(3).func_77973_b() == result[1].func_77973_b() && this.inventory.getStackInSlot(3).func_190916_E() < this.inventory.getStackInSlot(3).func_77976_d())) {
            for (int i = 2; i <= 3; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) {
                    this.inventory.setStackInSlot(i, result[i - 2].func_77946_l());
                    continue;
                }
                this.inventory.getStackInSlot(i).func_190917_f(1);
            }
            if (result[0].func_77973_b() == ModItems.particle_digamma) {
                List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72314_b(128.0, 50.0, 128.0));
                for (EntityPlayer player : players) {
                    AdvancementManager.grantAchievement(player, AdvancementManager.achOmega12);
                }
            }
        }
        this.field_145850_b.func_184148_a(null, (double)p.posX, (double)p.posY, (double)p.posZ, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 2.0f, 1.0f);
        this.delay = 20;
        this.state = EnumHadronState.SUCCESS;
        this.setStats(this.state, p.momentum, true);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.analysisOnly = data.func_74767_n("analysis");
        this.hopperMode = data.func_74767_n("hopperMode");
        this.state = EnumHadronState.values()[data.func_74771_c("state")];
        this.stat_success = data.func_74767_n("stat_success");
        this.stat_state = EnumHadronState.values()[data.func_74771_c("stat_state")];
        this.stat_charge = data.func_74762_e("stat_charge");
        this.stat_x = data.func_74762_e("stat_x");
        this.stat_y = data.func_74762_e("stat_y");
        this.stat_z = data.func_74762_e("stat_z");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (meta == 1) {
            boolean bl = this.analysisOnly = !this.analysisOnly;
        }
        if (meta == 2) {
            this.hopperMode = !this.hopperMode;
        }
    }

    private void drawPower() {
        for (ForgeDirection dir : this.getRandomDirs()) {
            int z;
            int y;
            if (this.power == 10000000L) {
                return;
            }
            int x = this.field_174879_c.func_177958_n() + dir.offsetX * 2;
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y = this.field_174879_c.func_177956_o() + dir.offsetY * 2, z = this.field_174879_c.func_177952_p() + dir.offsetZ * 2));
            if (!(te instanceof TileEntityHadronPower)) continue;
            TileEntityHadronPower plug = (TileEntityHadronPower)te;
            long toDraw = Math.min(10000000L - this.power, plug.getPower());
            this.setPower(this.power + toDraw);
            plug.setPower(plug.getPower() - toDraw);
        }
    }

    private void finishParticle(Particle p) {
        this.particlesToRemove.add(p);
        if (!p.isExpired()) {
            this.process(p);
        }
        p.expired = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74772_a("power", this.power);
        compound.func_74757_a("analysis", this.analysisOnly);
        compound.func_74757_a("hopperMode", this.hopperMode);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.isOn = compound.func_74767_n("isOn");
        this.power = compound.func_74763_f("power");
        this.analysisOnly = compound.func_74767_n("analysis");
        this.hopperMode = compound.func_74767_n("hopperMode");
        super.func_145839_a(compound);
    }

    public int getPowerScaled(int i) {
        return (int)(this.power * (long)i / 10000000L);
    }

    private void updateParticles() {
        for (Particle particle : this.particles) {
            particle.update();
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
        this.func_70296_d();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    private void setStats(EnumHadronState state, int count, boolean success) {
        this.stat_state = state;
        this.stat_charge = count;
        this.stat_success = success;
    }

    private void setExpireStats(EnumHadronState state, int count, int x, int y, int z) {
        this.stat_state = state;
        this.stat_charge = count;
        this.stat_x = x;
        this.stat_y = y;
        this.stat_z = z;
        this.stat_success = false;
    }

    public void makeSteppy(Particle p) {
        ForgeDirection dir = p.dir;
        p.posX += dir.offsetX;
        p.posY += dir.offsetY;
        p.posZ += dir.offsetZ;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        IBlockState blockState = this.field_145850_b.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileEntityHadron) {
            if (p.analysis != 3) {
                p.expire(EnumHadronState.ERROR_NO_ANALYSIS);
            } else {
                this.finishParticle(p);
            }
            return;
        }
        if (blockState.func_185904_a() != Material.field_151579_a && block != ModBlocks.hadron_diode) {
            p.expire(EnumHadronState.ERROR_OBSTRUCTED_CHANNEL);
        }
        if (block == ModBlocks.hadron_diode) {
            p.isCheckExempt = true;
        }
        if (this.coilValue(this.field_145850_b.func_180495_p(new BlockPos(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)).func_177230_c()) > 0) {
            p.isCheckExempt = true;
        }
    }

    public void checkSegment(Particle p) {
        ForgeDirection dir = p.dir;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        int dX = 1 - Math.abs(dir.offsetX);
        int dY = 1 - Math.abs(dir.offsetY);
        int dZ = 1 - Math.abs(dir.offsetZ);
        boolean analysis = true;
        for (int a = x - dX * 2; a <= x + dX * 2; ++a) {
            for (int b = y - dY * 2; b <= y + dY * 2; ++b) {
                for (int c = z - dZ * 2; c <= z + dZ * 2; ++c) {
                    IBlockState blockState = this.field_145850_b.func_180495_p(new BlockPos(a, b, c));
                    Block block = blockState.func_177230_c();
                    if (a == x && b == y && c == z) {
                        if (blockState.func_185904_a() == Material.field_151579_a) continue;
                        analysis = false;
                        continue;
                    }
                    int ix = Math.abs(x - a);
                    int iy = Math.abs(y - b);
                    int iz = Math.abs(z - c);
                    if (ix <= 1 && iy <= 1 && iz <= 1) {
                        if (p.isCheckExempt && ix + iy + iz == 1 || blockState.func_185904_a() == Material.field_151579_a && analysis) continue;
                        analysis = false;
                        int coilVal = this.coilValue(block);
                        if (coilVal == 0) {
                            p.expire(EnumHadronState.ERROR_EXPECTED_COIL);
                            continue;
                        }
                        p.momentum += coilVal;
                        p.charge -= coilVal;
                        continue;
                    }
                    if (ix + iy + iz > 3 || this.isAnalysis(block)) continue;
                    analysis = false;
                    if (this.isPlating(block)) continue;
                    TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(a, b, c));
                    if (te instanceof TileEntityHadronPower) {
                        TileEntityHadronPower plug = (TileEntityHadronPower)te;
                        long bit = 10000L;
                        int times = (int)(plug.getPower() / bit);
                        p.charge += times;
                        plug.setPower(plug.getPower() - (long)times * bit);
                        continue;
                    }
                    if (p.isCheckExempt && ix + iy + iz == 2) continue;
                    p.expire(EnumHadronState.ERROR_MALFORMED_SEGMENT);
                }
            }
        }
        if (analysis) {
            ++p.analysis;
            if (p.analysis > 3) {
                p.expire(EnumHadronState.ERROR_ANALYSIS_TOO_LONG);
            }
            if (p.analysis == 2) {
                this.field_145850_b.func_184148_a(null, (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5, SoundEvents.field_187619_bk, SoundCategory.BLOCKS, 2.0f, 2.0f);
                this.state = EnumHadronState.ANALYSIS;
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "hadron");
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5, 25.0));
            }
            if (this.analysisOnly && p.analysis == 2) {
                this.finishParticle(p);
            }
        } else if (p.analysis > 0 && p.analysis < 3) {
            p.expire(EnumHadronState.ERROR_ANALYSIS_TOO_SHORT);
        }
    }

    public void changeDirection(Particle p) {
        List<ForgeDirection> dirs;
        ForgeDirection dir = p.dir;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        int nx = x + dir.offsetX;
        int ny = y + dir.offsetY;
        int nz = z + dir.offsetZ;
        IBlockState nextState = this.field_145850_b.func_180495_p(new BlockPos(nx, ny, nz));
        Block next = nextState.func_177230_c();
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(nx, ny, nz));
        if (te instanceof TileEntityHadronDiode) {
            TileEntityHadronDiode diode = (TileEntityHadronDiode)te;
            if (diode.getConfig(p.dir.getOpposite().ordinal()) != TileEntityHadronDiode.DiodeConfig.IN) {
                p.expire(EnumHadronState.ERROR_DIODE_COLLISION);
            }
            p.isCheckExempt = true;
            return;
        }
        te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileEntityHadronDiode) {
            p.isCheckExempt = true;
            TileEntityHadronDiode diode = (TileEntityHadronDiode)te;
            if (diode.getConfig(dir.ordinal()) == TileEntityHadronDiode.DiodeConfig.OUT) {
                return;
            }
            dirs = this.getRandomDirs();
            for (ForgeDirection d : dirs) {
                if (d == dir || d == dir.getOpposite() || diode.getConfig(d.ordinal()) != TileEntityHadronDiode.DiodeConfig.OUT) continue;
                p.dir = d;
                return;
            }
        }
        if (nextState.func_185904_a() == Material.field_151579_a || next == ModBlocks.hadron_core) {
            return;
        }
        if (this.coilValue(next) > 0) {
            ForgeDirection validDir = ForgeDirection.UNKNOWN;
            dirs = this.getRandomDirs();
            for (ForgeDirection d : dirs) {
                if (d == dir || d == dir.getOpposite() || this.field_145850_b.func_180495_p(new BlockPos(x + d.offsetX, y + d.offsetY, z + d.offsetZ)).func_185904_a() != Material.field_151579_a) continue;
                if (validDir == ForgeDirection.UNKNOWN) {
                    validDir = d;
                    continue;
                }
                p.expire(EnumHadronState.ERROR_BRANCHING_TURN);
                return;
            }
            p.dir = validDir;
            p.isCheckExempt = true;
            return;
        }
        p.expire(EnumHadronState.ERROR_OBSTRUCTED_CHANNEL);
    }

    private List<ForgeDirection> getRandomDirs() {
        List<Integer> rands = Arrays.asList(0, 1, 2, 3, 4, 5);
        Collections.shuffle(rands);
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (Integer i : rands) {
            dirs.add(ForgeDirection.getOrientation(i));
        }
        return dirs;
    }

    public int coilValue(Block b) {
        if (b instanceof BlockHadronCoil) {
            return ((BlockHadronCoil)b).factor;
        }
        return 0;
    }

    public boolean isPlating(Block b) {
        return b instanceof BlockHadronPlating || b instanceof BlockHadronCoil || b == ModBlocks.hadron_plating_glass || b == ModBlocks.hadron_analysis_glass || b == ModBlocks.hadron_access;
    }

    public boolean isAnalysis(Block b) {
        return b == ModBlocks.hadron_analysis || b == ModBlocks.hadron_analysis_glass;
    }

    public static enum EnumHadronState {
        IDLE(0x8080FF),
        PROGRESS(0xFFFF00),
        ANALYSIS(0xFFFF00),
        NORESULT(0xFF8000),
        NORESULT_TOO_SLOW(0xFF8000),
        NORESULT_WRONG_INGREDIENT(0xFF8000),
        NORESULT_WRONG_MODE(0xFF8000),
        SUCCESS(65280),
        ERROR_NO_CHARGE(0xFF0000, true),
        ERROR_NO_ANALYSIS(0xFF0000, true),
        ERROR_OBSTRUCTED_CHANNEL(0xFF0000, true),
        ERROR_EXPECTED_COIL(0xFF0000, true),
        ERROR_MALFORMED_SEGMENT(0xFF0000, true),
        ERROR_ANALYSIS_TOO_LONG(0xFF0000, true),
        ERROR_ANALYSIS_TOO_SHORT(0xFF0000, true),
        ERROR_DIODE_COLLISION(0xFF0000, true),
        ERROR_BRANCHING_TURN(0xFF0000, true),
        ERROR_GENERIC(0xFF0000, true);

        public int color;
        public boolean showCoord;

        private EnumHadronState(int color) {
            this(color, false);
        }

        private EnumHadronState(int color, boolean showCoord) {
            this.color = color;
            this.showCoord = showCoord;
        }
    }

    public class Particle {
        ItemStack item1;
        ItemStack item2;
        ForgeDirection dir;
        int posX;
        int posY;
        int posZ;
        int momentum;
        int charge;
        int analysis;
        boolean isCheckExempt = false;
        boolean expired = false;

        public Particle(ItemStack item1, ItemStack item2, ForgeDirection dir, int posX, int posY, int posZ) {
            this.item1 = item1.func_77946_l();
            this.item2 = item2.func_77946_l();
            this.item1.func_190920_e(1);
            this.item2.func_190920_e(1);
            this.dir = dir;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.charge = 0;
            this.momentum = 0;
        }

        public void expire(EnumHadronState reason) {
            if (this.expired) {
                return;
            }
            this.expired = true;
            TileEntityHadron.this.particlesToRemove.add(this);
            TileEntityHadron.this.field_145850_b.func_72885_a(null, (double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5, 10.0f, false, false);
            TileEntityHadron.this.state = reason;
            TileEntityHadron.this.delay = 100;
            TileEntityHadron.this.setExpireStats(reason, this.momentum, this.posX, this.posY, this.posZ);
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void update() {
            if (this.expired) {
                return;
            }
            TileEntityHadron.this.changeDirection(this);
            TileEntityHadron.this.makeSteppy(this);
            if (!this.isExpired()) {
                TileEntityHadron.this.checkSegment(this);
            }
            this.isCheckExempt = false;
            if (this.charge <= 0) {
                this.expire(EnumHadronState.ERROR_NO_CHARGE);
            }
        }
    }
}

