/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineSILEX;
import com.hbm.items.machine.ItemFELCrystal;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntitySILEX;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityFEL
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public static final long maxPower = 2000000000L;
    public static final int powerReq = 1000;
    public ItemFELCrystal.EnumWavelengths mode = ItemFELCrystal.EnumWavelengths.NULL;
    public boolean isOn;
    public boolean missingValidSilex = true;
    public int distance;
    public List<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();

    public TileEntityFEL() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.machineFEL";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * -5, 1, dir.offsetZ * -5), dir);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 2000000000L);
            if (this.isOn && this.inventory.getStackInSlot(1).func_190916_E() != 0) {
                if (this.inventory.getStackInSlot(1).func_77973_b() instanceof ItemFELCrystal) {
                    ItemFELCrystal crystal = (ItemFELCrystal)this.inventory.getStackInSlot(1).func_77973_b();
                    this.mode = crystal.wavelength;
                } else {
                    this.mode = ItemFELCrystal.EnumWavelengths.NULL;
                }
            } else {
                this.mode = ItemFELCrystal.EnumWavelengths.NULL;
            }
            int range = 24;
            boolean silexSpacing = false;
            double xCoord = this.field_174879_c.func_177958_n();
            double yCoord = this.field_174879_c.func_177956_o();
            double zCoord = this.field_174879_c.func_177952_p();
            if (this.isOn && this.mode != ItemFELCrystal.EnumWavelengths.NULL) {
                if ((double)this.power < 1000.0 * Math.pow(4.0, this.mode.ordinal())) {
                    this.power = 0L;
                } else {
                    int distance = this.distance - 1;
                    double blx = Math.min(xCoord, xCoord + (double)dir.offsetX * (double)distance) + 0.2;
                    double bux = Math.max(xCoord, xCoord + (double)dir.offsetX * (double)distance) + 0.8;
                    double bly = Math.min(yCoord, 1.0 + yCoord + (double)dir.offsetY * (double)distance) + 0.2;
                    double buy = Math.max(yCoord, 1.0 + yCoord + (double)dir.offsetY * (double)distance) + 0.8;
                    double blz = Math.min(zCoord, zCoord + (double)dir.offsetZ * (double)distance) + 0.2;
                    double buz = Math.max(zCoord, zCoord + (double)dir.offsetZ * (double)distance) + 0.8;
                    List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(blx, bly, blz, bux, buy, buz));
                    for (EntityLivingBase entity : list) {
                        switch (this.mode) {
                            case RADIO: {
                                break;
                            }
                            case MICRO: {
                                entity.func_70015_d(2);
                                break;
                            }
                            case IR: {
                                entity.func_70015_d(4);
                                break;
                            }
                            case VISIBLE: {
                                entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)15), 0xE100000, 0));
                                break;
                            }
                            case UV: {
                                entity.func_70015_d(10);
                                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.025f);
                                break;
                            }
                            case XRAY: {
                                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 1.0f);
                                break;
                            }
                            case GAMMA: {
                                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 1000.0f);
                                if (!(Math.random() < 0.01)) break;
                                entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)3), 1800, 4, false, false));
                                entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)5), 1800, 6, false, false));
                                entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 1800, 6, false, false));
                                entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)11), 1800, 6, false, false));
                                entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)21), 1800, 4, false, false));
                                break;
                            }
                            case DRX: {
                                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 21000.0f);
                                ContaminationUtil.applyDigammaData((Entity)entity, 0.1f);
                            }
                        }
                    }
                    this.power = (long)((double)this.power - 1000.0 * (this.mode.ordinal() == 0 ? 0.0 : Math.pow(4.0, this.mode.ordinal())));
                    for (int i = 3; i < range; ++i) {
                        double x = xCoord + (double)(dir.offsetX * i);
                        double y = yCoord + 1.0;
                        double z = zCoord + (double)(dir.offsetZ * i);
                        IBlockState b = this.field_145850_b.func_180495_p(new BlockPos(x, y, z));
                        if (!b.func_185904_a().func_76218_k() && b != Blocks.field_150335_W) {
                            this.distance = range;
                            silexSpacing = false;
                            continue;
                        }
                        if (b.func_177230_c() == ModBlocks.machine_silex) {
                            BlockPos silex_pos = new BlockPos(x + (double)dir.offsetX, yCoord, z + (double)dir.offsetZ);
                            TileEntity te = this.field_145850_b.func_175625_s(silex_pos);
                            if (!(te instanceof TileEntitySILEX)) continue;
                            TileEntitySILEX silex = (TileEntitySILEX)te;
                            int meta = silex.func_145832_p() - 10;
                            if (this.rotationIsValid(meta, this.func_145832_p() - 10) && i >= 5 && !silexSpacing) {
                                if (silex.mode == this.mode) continue;
                                silex.mode = this.mode;
                                this.missingValidSilex = false;
                                silexSpacing = true;
                                continue;
                            }
                            MachineSILEX silexBlock = (MachineSILEX)silex.func_145838_q();
                            this.field_145850_b.func_175698_g(silex_pos);
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, x + 0.5, y + 0.5, z + 0.5, new ItemStack(Item.func_150898_a((Block)ModBlocks.machine_silex))));
                            continue;
                        }
                        if (b.func_177230_c() == Blocks.field_150350_a) continue;
                        this.distance = i;
                        float hardness = b.func_177230_c().func_149638_a(null);
                        boolean blocked = false;
                        switch (this.mode) {
                            case RADIO: {
                                blocked = true;
                                break;
                            }
                            case MICRO: {
                                if (b.func_185904_a().func_76224_d()) {
                                    this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    this.field_145850_b.func_175698_g(new BlockPos(x, y, z));
                                    break;
                                }
                                if (b.func_185904_a() != Material.field_151592_s && !b.func_185904_a().func_76218_k()) break;
                                blocked = true;
                                break;
                            }
                            case IR: {
                                if (!b.func_185904_a().func_76218_k() && b.func_185904_a() != Material.field_151592_s) break;
                                blocked = true;
                                break;
                            }
                            case VISIBLE: {
                                if (!b.func_185904_a().func_76218_k()) break;
                                if (hardness < 10.0f && this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                                    this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    this.field_145850_b.func_175656_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P());
                                    break;
                                }
                                blocked = true;
                                break;
                            }
                            case UV: {
                                if (!b.func_185904_a().func_76218_k()) break;
                                if (hardness < 100.0f && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                                    this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    this.field_145850_b.func_175656_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P());
                                    break;
                                }
                                blocked = true;
                                break;
                            }
                            case XRAY: {
                                if (!b.func_185904_a().func_76218_k()) break;
                                if (hardness < 1000.0f && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                                    this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    this.field_145850_b.func_175656_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P());
                                    break;
                                }
                                blocked = true;
                                break;
                            }
                            case GAMMA: {
                                if (!b.func_185904_a().func_76218_k()) break;
                                if (hardness < 3000.0f && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                                    this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    this.field_145850_b.func_175656_a(new BlockPos(x, y, z), ModBlocks.balefire.func_176223_P());
                                    break;
                                }
                                blocked = true;
                                break;
                            }
                            case DRX: {
                                this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                this.field_145850_b.func_175656_a(new BlockPos(x, y, z), (MainRegistry.polaroidID == 11 ? ModBlocks.digamma_matter : ModBlocks.fire_digamma).func_176223_P());
                                this.field_145850_b.func_175656_a(new BlockPos(x, y - 1.0, z), ModBlocks.ash_digamma.func_176223_P());
                            }
                        }
                        if (blocked) break;
                    }
                }
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74778_a("mode", this.mode.toString());
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("valid", this.missingValidSilex);
            data.func_74768_a("distance", this.distance);
            this.networkPack(data, 250);
        }
    }

    public boolean rotationIsValid(int silexMeta, int felMeta) {
        ForgeDirection felDir;
        ForgeDirection silexDir = ForgeDirection.getOrientation(silexMeta);
        return silexDir == (felDir = ForgeDirection.getOrientation(felMeta)) || silexDir == felDir.getOpposite();
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(nbt.func_74779_i("mode"));
        this.isOn = nbt.func_74767_n("isOn");
        this.distance = nbt.func_74762_e("distance");
        this.missingValidSilex = nbt.func_74767_n("valid");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 2) {
            this.isOn = !this.isOn;
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 2000000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(nbt.func_74779_i("mode"));
        this.isOn = nbt.func_74767_n("isOn");
        this.missingValidSilex = nbt.func_74767_n("valid");
        this.distance = nbt.func_74762_e("distance");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74778_a("mode", this.mode.name());
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("valid", this.missingValidSilex);
        nbt.func_74768_a("distance", this.distance);
        return nbt;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 2000000000L;
    }
}

