/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.render.amlfrom1710.Tessellator;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class BeamPronter {
    private static boolean depthMask = false;

    public static void prontBeamwithDepth(Vec3 skeleton, EnumWaveType wave, EnumBeamType beam, int outerColor, int innerColor, int start, int segments, float size, int layers, float thickness) {
        depthMask = true;
        BeamPronter.prontBeam(skeleton, wave, beam, outerColor, innerColor, start, segments, size, layers, thickness);
        depthMask = false;
    }

    public static void prontBeam(Vec3 skeleton, EnumWaveType wave, EnumBeamType beam, int outerColor, int innerColor, int start, int segments, float size, int layers, float thickness) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)depthMask);
        float sYaw = (float)(Math.atan2(skeleton.xCoord, skeleton.zCoord) * 180.0 / Math.PI);
        float sqrt = MathHelper.func_76133_a((double)(skeleton.xCoord * skeleton.xCoord + skeleton.zCoord * skeleton.zCoord));
        float sPitch = (float)(Math.atan2(skeleton.yCoord, sqrt) * 180.0 / Math.PI);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)sYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(sPitch - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        if (beam == EnumBeamType.SOLID) {
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
        }
        Tessellator tessellator = Tessellator.instance;
        Vec3 unit = Vec3.createVectorHelper(0.0, 1.0, 0.0);
        Random rand = new Random(start);
        double length = skeleton.lengthVector();
        double segLength = length / (double)segments;
        double lastX = 0.0;
        double lastY = 0.0;
        double lastZ = 0.0;
        for (int i = 0; i <= segments; ++i) {
            Vec3 spinner = Vec3.createVectorHelper(size, 0.0, 0.0);
            if (wave == EnumWaveType.SPIRAL) {
                spinner.rotateAroundY((float)Math.PI * (float)start / 180.0f);
                spinner.rotateAroundY(0.7853982f * (float)i);
            } else if (wave == EnumWaveType.RANDOM) {
                spinner.rotateAroundY((float)Math.PI * 2 * rand.nextFloat());
                spinner.rotateAroundY((float)Math.PI * 2 * rand.nextFloat());
            }
            double pX = unit.xCoord * segLength * (double)i + spinner.xCoord;
            double pY = unit.yCoord * segLength * (double)i + spinner.yCoord;
            double pZ = unit.zCoord * segLength * (double)i + spinner.zCoord;
            if (beam == EnumBeamType.LINE && i > 0) {
                tessellator.startDrawing(3);
                tessellator.setColorOpaque_I(outerColor);
                tessellator.addVertex(pX, pY, pZ);
                tessellator.addVertex(lastX, lastY, lastZ);
                tessellator.draw();
            }
            if (beam == EnumBeamType.SOLID && i > 0) {
                float radius = thickness / (float)layers;
                for (int j = 1; j <= layers; ++j) {
                    float inter = (float)(j - 1) / (float)(layers - 1);
                    int r1 = (outerColor & 0xFF0000) >> 16;
                    int g1 = (outerColor & 0xFF00) >> 8;
                    int b1 = (outerColor & 0xFF) >> 0;
                    int r2 = (innerColor & 0xFF0000) >> 16;
                    int g2 = (innerColor & 0xFF00) >> 8;
                    int b2 = (innerColor & 0xFF) >> 0;
                    int r = (int)((float)r1 + (float)(r2 - r1) * inter) << 16;
                    int g = (int)((float)g1 + (float)(g2 - g1) * inter) << 8;
                    int b = (int)((float)b1 + (float)(b2 - b1) * inter) << 0;
                    int color = r | g | b;
                    tessellator.startDrawingQuads();
                    tessellator.setColorOpaque_I(color);
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setColorOpaque_I(color);
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setColorOpaque_I(color);
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setColorOpaque_I(color);
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.draw();
                }
            }
            lastX = pX;
            lastY = pY;
            lastZ = pZ;
        }
        if (beam == EnumBeamType.LINE) {
            tessellator.startDrawing(3);
            tessellator.setColorOpaque_I(innerColor);
            tessellator.addVertex(0.0, 0.0, 0.0);
            tessellator.addVertex(0.0, skeleton.lengthVector(), 0.0);
            tessellator.draw();
        }
        if (beam == EnumBeamType.SOLID) {
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public static enum EnumBeamType {
        SOLID,
        LINE;

    }

    public static enum EnumWaveType {
        RANDOM,
        SPIRAL;

    }
}

