/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.tileentity.INBTPacketReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NBTPacket
implements IMessage {
    PacketBuffer buffer;
    int x;
    int y;
    int z;

    public NBTPacket() {
    }

    public NBTPacket(NBTTagCompound nbt, BlockPos pos) {
        this.buffer = new PacketBuffer(Unpooled.buffer());
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.buffer.func_150786_a(nbt);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        if (this.buffer == null) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
        }
        this.buffer.writeBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        if (this.buffer == null) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
        }
        buf.writeBytes((ByteBuf)this.buffer);
    }

    public static class Handler
    implements IMessageHandler<NBTPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(NBTPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (Minecraft.func_71410_x().field_71441_e == null) {
                    return;
                }
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(m.x, m.y, m.z));
                try {
                    NBTTagCompound nbt = m.buffer.func_150793_b();
                    if (nbt != null && te instanceof INBTPacketReceiver) {
                        ((INBTPacketReceiver)te).networkUnpack(nbt);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            return null;
        }
    }
}

