/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.capability.HbmCapability;
import com.hbm.handler.HbmKeybinds;
import com.hbm.items.gear.ArmorFSB;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KeybindPacket
implements IMessage {
    int id;
    int key;
    boolean pressed;

    public KeybindPacket() {
    }

    public KeybindPacket(HbmKeybinds.EnumKeybind key, boolean pressed) {
        this.key = key.ordinal();
        this.pressed = pressed;
        this.id = 0;
    }

    public KeybindPacket(int id) {
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.key = buf.readInt();
        this.pressed = buf.readBoolean();
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.key);
        buf.writeBoolean(this.pressed);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<KeybindPacket, IMessage> {
        public IMessage onMessage(KeybindPacket m, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                    switch (m.id) {
                        case 0: {
                            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
                            HbmCapability.IHBMData props = HbmCapability.getData((Entity)p);
                            props.setKeyPressed(HbmKeybinds.EnumKeybind.values()[m.key], m.pressed);
                            break;
                        }
                        case 1: {
                            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                            if (!ArmorFSB.hasFSBArmor((EntityLivingBase)player)) break;
                            ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
                            ArmorFSB fsbarmor = (ArmorFSB)stack.func_77973_b();
                            if (fsbarmor.flashlightPosition == null) break;
                            if (!stack.func_77942_o()) {
                                stack.func_77982_d(new NBTTagCompound());
                            }
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.5f, 1.0f);
                            stack.func_77978_p().func_74757_a("flActive", !stack.func_77978_p().func_74767_n("flActive"));
                        }
                    }
                });
            } else {
                this.handleClient(ctx, m);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void handleClient(MessageContext ctx, KeybindPacket m) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                HbmCapability.IHBMData props = HbmCapability.getData((Entity)Minecraft.func_71410_x().field_71439_g);
                if (HbmKeybinds.EnumKeybind.values()[m.key] == HbmKeybinds.EnumKeybind.TOGGLE_JETPACK) {
                    props.setEnableBackpack(m.pressed);
                }
                if (HbmKeybinds.EnumKeybind.values()[m.key] == HbmKeybinds.EnumKeybind.TOGGLE_HEAD) {
                    props.setEnableHUD(m.pressed);
                }
            });
        }
    }
}

