/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.items.weapon.ItemGunBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class GunButtonPacket
implements IMessage {
    boolean state;
    byte button;
    EnumHand hand;

    public GunButtonPacket() {
    }

    public GunButtonPacket(boolean m1, byte b, EnumHand hand) {
        this.state = m1;
        this.button = b;
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        this.state = buf.readBoolean();
        this.button = buf.readByte();
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.state);
        buf.writeByte((int)this.button);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
    }

    public static class Handler
    implements IMessageHandler<GunButtonPacket, IMessage> {
        public IMessage onMessage(GunButtonPacket m, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    return;
                }
                EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
                if (p.func_184586_b(m.hand) != null && p.func_184586_b(m.hand).func_77973_b() instanceof ItemGunBase) {
                    ItemGunBase item = (ItemGunBase)p.func_184586_b(m.hand).func_77973_b();
                    switch (m.button) {
                        case 0: {
                            ItemGunBase.setIsMouseDown(p.func_184586_b(m.hand), m.state);
                            if (m.state) {
                                item.startAction(p.func_184586_b(m.hand), p.field_70170_p, (EntityPlayer)p, true, m.hand);
                                break;
                            }
                            item.endAction(p.func_184586_b(m.hand), p.field_70170_p, (EntityPlayer)p, true, m.hand);
                            break;
                        }
                        case 1: {
                            ItemGunBase.setIsAltDown(p.func_184586_b(m.hand), m.state);
                            if (m.state) {
                                item.startAction(p.func_184586_b(m.hand), p.field_70170_p, (EntityPlayer)p, false, m.hand);
                                break;
                            }
                            item.endAction(p.func_184586_b(m.hand), p.field_70170_p, (EntityPlayer)p, false, m.hand);
                            break;
                        }
                        case 2: {
                            if (!item.canReload(p.func_184586_b(m.hand), p.field_70170_p, (EntityPlayer)p)) break;
                            item.startReloadAction(p.func_184586_b(m.hand), p.field_70170_p, (EntityPlayer)p, m.hand);
                        }
                    }
                }
            });
            return null;
        }
    }
}

