/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.tileentity.machine.TileEntityControlPanel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlPanelUpdatePacket
implements IMessage {
    PacketBuffer buffer;
    int x;
    int y;
    int z;
    List<VarUpdate> toUpdate;

    public ControlPanelUpdatePacket() {
    }

    public ControlPanelUpdatePacket(BlockPos pos, List<VarUpdate> toUpdate) {
        this.toUpdate = toUpdate;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.buffer = new PacketBuffer(Unpooled.buffer());
    }

    public ControlPanelUpdatePacket(BlockPos pos, NBTTagCompound tag) {
        this.toUpdate = null;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.buffer = new PacketBuffer(Unpooled.buffer());
        this.buffer.func_150786_a(tag);
    }

    public void fromBytes(ByteBuf buf) {
        if (this.buffer == null) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
        }
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int size = buf.readInt();
        if (size == -1) {
            this.buffer.writeBytes(buf);
        } else {
            this.buffer.writeBytes(buf);
            this.toUpdate = new ArrayList<VarUpdate>(size);
            for (int i = 0; i < size; ++i) {
                VarUpdate u = new VarUpdate();
                u.varListIdx = this.buffer.readInt();
                u.varName = this.buffer.func_150789_c(32);
                this.toUpdate.add(u);
            }
            try {
                NBTTagCompound tag = this.buffer.func_150793_b();
                for (int i = 0; i < size; ++i) {
                    this.toUpdate.get((int)i).data = DataValue.newFromNBT(tag.func_74781_a("" + i));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        if (this.toUpdate == null) {
            buf.writeInt(-1);
            buf.writeBytes((ByteBuf)this.buffer);
        } else {
            buf.writeInt(this.toUpdate.size());
            NBTTagCompound tag = new NBTTagCompound();
            int i = 0;
            for (VarUpdate u : this.toUpdate) {
                if (u != null) {
                    this.buffer.writeInt(u.varListIdx);
                    this.buffer.func_180714_a(u.varName);
                    if (u.data != null) {
                        tag.func_74782_a("" + i, u.data.writeToNBT());
                    }
                }
                ++i;
            }
            this.buffer.func_150786_a(tag);
            buf.writeBytes((ByteBuf)this.buffer);
        }
    }

    public static class VarUpdate {
        public int varListIdx;
        public String varName;
        public DataValue data;

        public VarUpdate() {
        }

        public VarUpdate(int varListIdx, String varName, DataValue data) {
            this.varListIdx = varListIdx;
            this.varName = varName;
            this.data = data;
        }
    }

    public static class Handler
    implements IMessageHandler<ControlPanelUpdatePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ControlPanelUpdatePacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                BlockPos pos = new BlockPos(m.x, m.y, m.z);
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
                if (te instanceof TileEntityControlPanel) {
                    ControlPanel control = ((TileEntityControlPanel)te).panel;
                    if (m.toUpdate == null) {
                        try {
                            NBTTagCompound tag = m.buffer.func_150793_b();
                            control.readFromNBT(tag);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        for (VarUpdate u : m.toUpdate) {
                            if (u.varName == null) continue;
                            if (u.varListIdx == -1) {
                                if (u.data == null) {
                                    control.globalVars.remove(u.varName);
                                    continue;
                                }
                                control.globalVars.put(u.varName, u.data);
                                continue;
                            }
                            if (u.varListIdx >= control.controls.size()) continue;
                            if (u.data == null) {
                                control.controls.get((int)u.varListIdx).vars.remove(u.varName);
                                continue;
                            }
                            control.controls.get((int)u.varListIdx).vars.put(u.varName, u.data);
                        }
                    }
                }
            });
            return null;
        }
    }
}

