/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.BedrockOreRegistry;
import com.hbm.items.tool.ItemSatInterface;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.SatLaserPacket;
import com.hbm.render.RenderHelper;
import com.hbm.saveddata.satellites.Satellite;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GUIScreenSatInterface
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/satellites/gui_sat_interface.png");
    protected int xSize = 216;
    protected int ySize = 216;
    protected int guiLeft;
    protected int guiTop;
    private final EntityPlayer player;
    int x;
    int z;
    private int scanPos = 0;
    private long lastMilli = 0L;
    private int[][] map = new int[200][200];

    public GUIScreenSatInterface(EntityPlayer player) {
        this.player = player;
    }

    public void func_73876_c() {
    }

    protected void func_73864_a(int i, int j, int k) {
        if (ItemSatInterface.currentSat != null && ItemSatInterface.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.CAN_CLICK) && i >= this.guiLeft + 8 && i < this.guiLeft + 208 && j >= this.guiTop + 8 && j < this.guiTop + 208 && this.player != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)HBMSoundHandler.techBleep, (float)1.0f));
            int x = this.x - this.guiLeft + i - 8 - 100;
            int z = this.z - this.guiTop + j - 8 - 100;
            PacketDispatcher.wrapper.sendToServer((IMessage)new SatLaserPacket(x, z, ItemSatInterface.getFreq(this.player.func_184614_ca())));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.func_179140_f();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.func_179145_e();
    }

    public void func_146278_c(int tint) {
        super.func_146276_q_();
        super.func_146278_c(tint);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.x = (int)this.player.field_70165_t;
        this.z = (int)this.player.field_70161_v;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        if (ItemSatInterface.currentSat != null && ItemSatInterface.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.SHOW_COORDS) && i >= this.guiLeft + 8 && i < this.guiLeft + 208 && j >= this.guiTop + 8 && j < this.guiTop + 208 && this.player != null) {
            int x = this.x - this.guiLeft + i - 8 - 100;
            int z = this.z - this.guiTop + j - 8 - 100;
            this.func_146283_a(Arrays.asList(x + " / " + z), i, j);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (ItemSatInterface.currentSat == null) {
            this.drawNotConnected();
        } else {
            if (ItemSatInterface.currentSat.satIface != Satellite.Interfaces.SAT_PANEL) {
                this.drawNoService();
                return;
            }
            if (ItemSatInterface.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.HAS_MAP)) {
                this.drawMap();
            }
            if (ItemSatInterface.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.HAS_ORES)) {
                this.drawScan();
            }
            if (ItemSatInterface.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.HAS_RADAR)) {
                this.drawRadar();
            }
        }
    }

    private void progresScan() {
        if (this.lastMilli + 15L < System.currentTimeMillis()) {
            this.lastMilli = System.currentTimeMillis();
            ++this.scanPos;
        }
        if (this.scanPos >= 200) {
            this.scanPos -= 200;
        }
    }

    private void drawMap() {
        World world = this.player.field_70170_p;
        for (int i = -100; i < 100; ++i) {
            int x = this.x + i;
            int z = this.z + this.scanPos - 100;
            int y = world.func_189649_b(x, z) - 1;
            this.map[i + 100][this.scanPos] = world.func_180495_p((BlockPos)new BlockPos((int)x, (int)y, (int)z)).func_185904_a().func_151565_r().field_76291_p;
        }
        this.prontMap();
        this.progresScan();
    }

    private void drawScan() {
        World world = this.player.field_70170_p;
        block0: for (int i = -100; i < 100; ++i) {
            int x = this.x + i;
            int z = this.z + this.scanPos - 100;
            for (int j = (int)this.player.field_70163_u; j >= 0; --j) {
                IBlockState state = world.func_180495_p(new BlockPos(x, j, z));
                int c = this.getColorFromBlock(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
                if (c == 0) continue;
                this.map[i + 100][this.scanPos] = c;
                continue block0;
            }
        }
        this.prontMap();
        this.progresScan();
    }

    private int getColorFromBlock(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || stack.func_190926_b()) {
            return 0;
        }
        int color = 0;
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            color = BedrockOreRegistry.getOreScanColor(OreDictionary.getOreName((int)id));
            if (color == 0) continue;
            return color;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) == ModBlocks.ore_bedrock_block) {
            return 16271360;
        }
        return 0;
    }

    private void drawRadar() {
        List entities = this.player.field_70170_p.func_72839_b((Entity)this.player, new AxisAlignedBB(this.player.field_70165_t - 100.0, 0.0, this.player.field_70161_v - 100.0, this.player.field_70165_t + 100.0, 5000.0, this.player.field_70161_v + 100.0));
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                if (!((double)(e.field_70130_N * e.field_70130_N * e.field_70131_O) >= 0.5)) continue;
                int x = (int)((e.field_70165_t - (double)this.x) / 201.0 * 192.0) - 4;
                int z = (int)((e.field_70161_v - (double)this.z) / 201.0 * 192.0) - 4 - 9;
                int t = 5;
                if (e instanceof EntityMob) {
                    t = 6;
                }
                if (e instanceof EntityPlayer) {
                    t = 7;
                }
                this.func_73729_b(this.guiLeft + 108 + x, this.guiTop + 117 + z, 216, 8 * t, 8, 8);
            }
        }
    }

    private void prontMap() {
        for (int x = 0; x < 200; ++x) {
            for (int z = 0; z < 200; ++z) {
                RenderHelper.setColor(this.map[x][z]);
                this.func_73729_b(this.guiLeft + 8 + x, this.guiTop + 8 + z, 216, 216, 1, 1);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawNoService() {
        this.func_73729_b((this.field_146294_l - 77) / 2, (this.field_146295_m - 12) / 2, 0, 228, 77, 12);
    }

    private void drawNotConnected() {
        this.func_73729_b((this.field_146294_l - 121) / 2, (this.field_146295_m - 12) / 2, 0, 216, 121, 12);
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.z -= 50;
            this.map = new int[200][200];
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.z += 50;
            this.map = new int[200][200];
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.x -= 50;
            this.map = new int[200][200];
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.x += 50;
            this.map = new int[200][200];
        }
    }
}

