/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.Node;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;

public class NodeInput
extends Node {
    public String name;

    public NodeInput(float x, float y, String name) {
        super(x, y);
        this.name = name;
    }

    @Override
    public DataValue evaluate(int idx) {
        return ((NodeConnection)this.outputs.get((int)idx)).defaultValue;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "input");
        tag.func_74778_a("name", this.name);
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.name = tag.func_74779_i(this.name);
        super.readFromNBT(tag, sys);
    }

    @Override
    public NodeType getType() {
        return NodeType.INPUT;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public NodeInput setVars(Map<String, DataValue> vars) {
        this.outputs.clear();
        for (Map.Entry<String, DataValue> e : vars.entrySet()) {
            NodeConnection c = new NodeConnection(e.getKey(), this, this.outputs.size(), false, e.getValue().getType(), e.getValue());
            this.outputs.add(c);
        }
        this.recalcSize();
        return this;
    }

    public NodeInput setOutputFromVars(Map<String, DataValue> vars) {
        for (NodeConnection c : this.outputs) {
            if (Objects.equals(c.name, "from index")) {
                c.enumSelector = null;
                continue;
            }
            c.setDefault(vars.get(c.name));
        }
        return this;
    }
}

