/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.Node;
import net.minecraft.nbt.NBTTagCompound;

public class NodeBuffer
extends Node {
    private int internalCount;

    public NodeBuffer(float x, float y) {
        super(x, y);
        this.inputs.add(new NodeConnection("Input", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        this.inputs.add(new NodeConnection("Delay", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        this.outputs.add(new NodeConnection("Output", this, this.outputs.size(), false, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        this.evalCache = new DataValue[1];
        this.recalcSize();
    }

    @Override
    public NodeType getType() {
        return NodeType.LOGIC;
    }

    @Override
    public String getDisplayName() {
        return "Buffer";
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "buffer");
        tag.func_74768_a("internalCount", this.internalCount);
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.internalCount = tag.func_74762_e("internalCount");
        super.readFromNBT(tag, sys);
    }

    @Override
    public DataValue evaluate(int inx) {
        if (this.cacheValid) {
            return this.evalCache[0];
        }
        this.cacheValid = true;
        DataValue in = ((NodeConnection)this.inputs.get(0)).evaluate();
        DataValue delay = ((NodeConnection)this.inputs.get(1)).evaluate();
        if (in == null || delay == null) {
            return null;
        }
        int delayInt = Math.abs(Math.round(delay.getNumber()));
        if (in.getBoolean() || this.internalCount != 0) {
            if (this.internalCount == delayInt) {
                this.internalCount = 0;
                this.evalCache[0] = in;
                return this.evalCache[0];
            }
            ++this.internalCount;
        }
        this.evalCache[0] = new DataValueFloat(0.0f);
        return this.evalCache[0];
    }
}

