/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlRegistry;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.inventory.control_panel.SubElement;
import com.hbm.inventory.control_panel.controls.configs.SubElementBaseConfig;
import com.hbm.inventory.control_panel.controls.configs.SubElementDialSquare;
import com.hbm.inventory.control_panel.controls.configs.SubElementDisplaySevenSeg;
import com.hbm.inventory.control_panel.controls.configs.SubElementDisplayText;
import com.hbm.inventory.control_panel.controls.configs.SubElementKnobControl;
import com.hbm.inventory.control_panel.controls.configs.SubElementLabel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SubElementItemConfig
extends SubElement {
    public static ResourceLocation bg_tex = new ResourceLocation("hbm:textures/gui/control_panel/gui_base.png");
    public GuiButton btn_done;
    public GuiButton btn_next;
    public GuiButton btn_prev;
    public List<String> variants = Collections.emptyList();
    private int curr_variant = 0;
    private int num_variants = 1;
    SubElementBaseConfig config_gui;
    private Map<String, DataValue> configs;
    Control last_control = null;
    Map<String, DataValue> existing_configs;

    public SubElementItemConfig(GuiControlEdit gui) {
        super(gui);
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.btn_prev = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 30, this.gui.getGuiTop() + 24, 15, 20, "<"));
        this.btn_next = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX + 15, this.gui.getGuiTop() + 24, 15, 20, ">"));
        this.btn_done = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 85, cY + 92, 170, 20, "Done"));
        this.config_gui = new SubElementDisplaySevenSeg(this.gui, ControlRegistry.registry.get("display_7seg").getConfigs());
        this.config_gui.initGui();
        super.initGui();
    }

    @Override
    protected void drawScreen() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.num_variants = this.variants.size() - 1;
        if (this.gui.isEditMode) {
            this.existing_configs = this.gui.currentEditControl.getConfigs();
            this.curr_variant = this.variants.indexOf(ControlRegistry.getName(this.gui.currentEditControl.getClass()));
        }
        this.btn_prev.field_146124_l = !this.gui.isEditMode;
        boolean bl = this.btn_next.field_146124_l = !this.gui.isEditMode;
        if (this.curr_variant > this.variants.size() - 1) {
            this.curr_variant = 0;
        }
        Control variant = ControlRegistry.getNew(this.variants.get(this.curr_variant), this.gui.control.panel);
        String text = variant.name;
        int text_width = this.gui.getFontRenderer().func_78256_a(text);
        this.gui.getFontRenderer().func_175065_a(text, (float)cX - (float)text_width / 2.0f + 0.0f, (float)(this.gui.getGuiTop() + 11), -8947849, false);
        text = this.curr_variant + 1 + "/" + (this.num_variants + 1);
        text_width = this.gui.getFontRenderer().func_78256_a(text);
        this.gui.getFontRenderer().func_175065_a(text, (float)cX - (float)text_width / 2.0f + 0.0f, (float)(this.gui.getGuiTop() + 30), -8947849, false);
        if (this.last_control == null || !variant.name.equals(this.last_control.name)) {
            this.config_gui.enableButtons(false);
            switch (this.variants.get(this.curr_variant)) {
                case "display_7seg": {
                    this.config_gui = new SubElementDisplaySevenSeg(this.gui, this.gui.isEditMode ? this.existing_configs : ControlRegistry.registry.get("display_7seg").getConfigs());
                    break;
                }
                case "display_text": {
                    this.config_gui = new SubElementDisplayText(this.gui, this.gui.isEditMode ? this.existing_configs : ControlRegistry.registry.get("display_text").getConfigs());
                    break;
                }
                case "knob_control": {
                    this.config_gui = new SubElementKnobControl(this.gui, this.gui.isEditMode ? this.existing_configs : ControlRegistry.registry.get("knob_control").getConfigs());
                    break;
                }
                case "label": {
                    this.config_gui = new SubElementLabel(this.gui, this.gui.isEditMode ? this.existing_configs : ControlRegistry.registry.get("label").getConfigs());
                    break;
                }
                case "dial_square": {
                    this.config_gui = new SubElementDialSquare(this.gui, this.gui.isEditMode ? this.existing_configs : ControlRegistry.registry.get("dial_square").getConfigs());
                    break;
                }
                case "dial_large": {
                    this.config_gui = new SubElementDialSquare(this.gui, this.gui.isEditMode ? this.existing_configs : ControlRegistry.registry.get("dial_large").getConfigs());
                    break;
                }
                default: {
                    this.config_gui = new SubElementBaseConfig(this.gui);
                }
            }
            if (!this.gui.isEditMode) {
                this.gui.currentEditControl = variant;
            }
            this.config_gui.initGui();
            this.config_gui.enableButtons(true);
            this.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
        }
        this.config_gui.drawScreen();
        this.last_control = variant;
    }

    @Override
    protected void renderBackground() {
        this.gui.field_146297_k.func_110434_K().func_110577_a(bg_tex);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop(), 0, 0, this.gui.getXSize(), this.gui.getYSize());
    }

    @Override
    protected void update() {
        this.config_gui.update();
    }

    @Override
    protected void mouseReleased(int mouseX, int mouseY, int state) {
        this.config_gui.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int button) {
        this.config_gui.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) {
        this.config_gui.keyTyped(typedChar, keyCode);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.btn_done) {
            this.configs = this.config_gui.getConfigs();
            this.gui.currentEditControl.applyConfigs(this.configs);
            if (this.gui.isEditMode) {
                this.gui.linker.linked.clear();
                World world = this.gui.control.func_145831_w();
                for (BlockPos p : this.gui.currentEditControl.connectedSet) {
                    TileEntity te = world.func_175625_s(p);
                    if (te instanceof IControllable) {
                        this.gui.linker.linked.add((IControllable)te);
                    }
                    this.gui.linker.refreshButtons();
                }
            }
            this.config_gui.enableButtons(false);
            this.last_control = null;
            this.gui.pushElement(this.gui.linker);
        } else if (button == this.btn_next) {
            this.curr_variant = Math.min(this.num_variants, this.curr_variant + 1);
        } else if (button == this.btn_prev) {
            this.curr_variant = Math.max(0, this.curr_variant - 1);
        }
    }

    @Override
    protected void enableButtons(boolean enable) {
        this.btn_done.field_146125_m = enable;
        this.btn_done.field_146124_l = enable;
        this.btn_next.field_146125_m = enable;
        this.btn_next.field_146124_l = enable;
        this.btn_prev.field_146125_m = enable;
        this.btn_prev.field_146124_l = enable;
    }
}

