/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.ItemList;
import com.hbm.inventory.control_panel.NodeElement;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.nodes.Node;
import com.hbm.render.RenderHelper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class NodeDropdown
extends NodeElement {
    public ItemList list;
    public Supplier<String> nameGetter;

    public NodeDropdown(Node parent, int idx, Function<String, ItemList> func, Supplier<String> nameGetter) {
        super(parent, idx);
        this.list = new ItemList(0.0f, 0.0f, 32.0f, func);
        this.list.alpha = 0.95f;
        this.list.b = 0.3f;
        this.list.g = 0.3f;
        this.list.r = 0.3f;
        this.list.textColor = -2105377;
        this.list.close();
        this.resetOffset();
        this.nameGetter = nameGetter;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        throw new RuntimeException("Dropdown node should not be serialized!");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        throw new RuntimeException("Dropdown node should not be serialized!");
    }

    @Override
    public void resetOffset() {
        super.resetOffset();
        if (this.list != null) {
            this.list.posX = this.offsetX + 4.0f;
            this.list.posY = this.offsetY + 14.0f;
        }
    }

    public void setOffset(float x, float y) {
        this.offsetX = x;
        this.offsetY = y;
        this.list.posX = x + 4.0f;
        this.list.posY = y + 14.0f;
    }

    @Override
    public void render(float mX, float mY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NodeSystem.node_tex);
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float x = this.offsetX + 4.0f;
        float y = this.offsetY + 8.0f;
        RenderHelper.drawGuiRectBatchedColor(x, y, 0.0f, 0.890625f, 32.0f, 6.0f, 0.609375f, 0.984375f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator.func_178181_a().func_78381_a();
        this.list.render(mX, mY);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)0.35, (double)0.35, (double)0.35);
        GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        String s = this.nameGetter.get();
        font.func_175065_a(s, x + 43.0f - (float)(font.func_78256_a(s) / 2), y + 5.0f, -10526881, false);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        float width = font.func_78263_a('^');
        float height = font.field_78288_b;
        GL11.glTranslated((double)((x += 27.5f) + width * 0.4f), (double)((y += 2.5f) + height * 0.2f), (double)0.0);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        if (this.list.isClosed) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glTranslated((double)(-x - width * 0.4f), (double)(-y - height * 0.2f), (double)0.0);
        font.func_175065_a("^", x, y, -10526881, false);
        GL11.glPopMatrix();
    }

    @Override
    public boolean onClick(float x, float y) {
        if (!this.list.isClosed && RenderHelper.intersects2DBox(x, y, this.list.getBoundingBox()) && this.list.mouseClicked(x, y)) {
            this.list.close();
            return true;
        }
        if (RenderHelper.intersects2DBox(x, y, this.getBox())) {
            if (this.list.isClosed) {
                this.list.open();
            } else {
                this.list.close();
            }
            return true;
        }
        return false;
    }

    public float[] getBox() {
        return new float[]{3.0f + this.offsetX, -3.0f + this.offsetY + 10.0f, 37.0f + this.offsetX, 3.0f + this.offsetY + 10.0f};
    }
}

