/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.forgefluid.ModForgeFluids;
import java.util.HashMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EngineRecipes {
    public static HashMap<Fluid, Long> combustionEnergies = new HashMap();
    public static HashMap<Fluid, FuelGrade> fuelGrades = new HashMap();

    public static void registerEngineRecipes() {
        EngineRecipes.addFuel(ModForgeFluids.hydrogen, FuelGrade.HIGH, 10000L);
        EngineRecipes.addFuel(ModForgeFluids.deuterium, FuelGrade.HIGH, 10000L);
        EngineRecipes.addFuel(ModForgeFluids.tritium, FuelGrade.HIGH, 10000L);
        EngineRecipes.addFuel(ModForgeFluids.heavyoil, FuelGrade.LOW, 25000L);
        EngineRecipes.addFuel(ModForgeFluids.heatingoil, FuelGrade.LOW, 100000L);
        EngineRecipes.addFuel(ModForgeFluids.reclaimed, FuelGrade.LOW, 200000L);
        EngineRecipes.addFuel(ModForgeFluids.petroil, FuelGrade.MEDIUM, 300000L);
        EngineRecipes.addFuel(ModForgeFluids.naphtha, FuelGrade.MEDIUM, 200000L);
        EngineRecipes.addFuel(ModForgeFluids.diesel, FuelGrade.HIGH, 500000L);
        EngineRecipes.addFuel(ModForgeFluids.lightoil, FuelGrade.MEDIUM, 500000L);
        EngineRecipes.addFuel(ModForgeFluids.kerosene, FuelGrade.AERO, 1250000L);
        EngineRecipes.addFuel(ModForgeFluids.biogas, FuelGrade.AERO, 500000L);
        EngineRecipes.addFuel(ModForgeFluids.biofuel, FuelGrade.HIGH, 400000L);
        EngineRecipes.addFuel(ModForgeFluids.nitan, FuelGrade.HIGH, 5000000L);
        EngineRecipes.addFuel(ModForgeFluids.balefire, FuelGrade.HIGH, 2500000L);
        EngineRecipes.addFuel(ModForgeFluids.gasoline, FuelGrade.HIGH, 1000000L);
        EngineRecipes.addFuel(ModForgeFluids.ethanol, FuelGrade.HIGH, 200000L);
        EngineRecipes.addFuel(ModForgeFluids.fishoil, FuelGrade.LOW, 50000L);
        EngineRecipes.addFuel(ModForgeFluids.sunfloweroil, FuelGrade.LOW, 80000L);
        EngineRecipes.addFuel(ModForgeFluids.gas, FuelGrade.GAS, 100000L);
        EngineRecipes.addFuel(ModForgeFluids.petroleum, FuelGrade.GAS, 300000L);
        EngineRecipes.addFuel(ModForgeFluids.aromatics, FuelGrade.GAS, 150000L);
        EngineRecipes.addFuel(ModForgeFluids.unsaturateds, FuelGrade.GAS, 250000L);
        EngineRecipes.addFuel("biofuel", FuelGrade.HIGH, 400000L);
        EngineRecipes.addFuel("petroil", FuelGrade.MEDIUM, 300000L);
        EngineRecipes.addFuel("refined_fuel", FuelGrade.HIGH, 1000000L);
        EngineRecipes.addFuel("refined_biofuel", FuelGrade.HIGH, 400000L);
    }

    public static long getEnergy(Fluid f) {
        if (f != null) {
            return combustionEnergies.get(f);
        }
        return 0L;
    }

    public static FuelGrade getFuelGrade(Fluid f) {
        if (f != null) {
            return fuelGrades.get(f);
        }
        return null;
    }

    public static boolean isAero(Fluid f) {
        return EngineRecipes.getFuelGrade(f) == FuelGrade.AERO;
    }

    public static void addFuel(Fluid f, FuelGrade g, long power) {
        if (f != null && power > 0L) {
            combustionEnergies.put(f, power);
            fuelGrades.put(f, g);
        }
    }

    public static boolean hasFuelRecipe(Fluid f) {
        if (f == null) {
            return false;
        }
        return combustionEnergies.containsKey(f);
    }

    public static void addFuel(String f, FuelGrade g, long power) {
        if (FluidRegistry.isFluidRegistered((String)f)) {
            EngineRecipes.addFuel(FluidRegistry.getFluid((String)f), g, power);
        }
    }

    public static void removeFuel(Fluid f) {
        if (f != null) {
            combustionEnergies.remove(f);
            fuelGrades.remove(f);
        }
    }

    public static void removeFuel(String f) {
        if (FluidRegistry.isFluidRegistered((String)f)) {
            EngineRecipes.removeFuel(FluidRegistry.getFluid((String)f));
        }
    }

    public static enum FuelGrade {
        LOW("trait.fuelgrade.low"),
        MEDIUM("trait.fuelgrade.medium"),
        HIGH("trait.fuelgrade.high"),
        AERO("trait.fuelgrade.aero"),
        GAS("trait.fuelgrade.gas");

        private String grade;

        private FuelGrade(String grade) {
            this.grade = grade;
        }

        public String getGrade() {
            return this.grade;
        }
    }
}

