/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.items.ModItems;

public class GunCannonFactory {
    public static BulletConfiguration getShellConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = ModItems.ammo_shell;
        bullet.dmgMin = 25.0f;
        bullet.dmgMax = 35.0f;
        bullet.explosive = 4.0f;
        bullet.blockDamage = false;
        return bullet;
    }

    public static BulletConfiguration getShellExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = ModItems.ammo_shell_explosive;
        bullet.dmgMin = 35.0f;
        bullet.dmgMax = 45.0f;
        bullet.explosive = 4.0f;
        bullet.blockDamage = true;
        return bullet;
    }

    public static BulletConfiguration getShellAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = ModItems.ammo_shell_apfsds_t;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 55.0f;
        bullet.doesPenetrate = true;
        bullet.style = 14;
        return bullet;
    }

    public static BulletConfiguration getShellDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = ModItems.ammo_shell_apfsds_du;
        bullet.dmgMin = 70.0f;
        bullet.dmgMax = 80.0f;
        bullet.doesPenetrate = true;
        bullet.style = 14;
        return bullet;
    }

    public static BulletConfiguration getShellW9Config() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = ModItems.ammo_shell_w9;
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 150.0f;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, 25);
            }
        };
        return bullet;
    }
}

