/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.ChemplantRecipes;
import com.hbm.inventory.RecipesCommon;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.Chemplant")
public class Chemplant {
    @ZenMethod
    public static void addChemplantRecipe(int index, String name, IItemStack[] inputItems, String[] inputFluids, Integer[] inputAmounts, IItemStack[] outputItems, String[] outputFluids, Integer[] outputAmounts, int duration) {
        CraftTweakerAPI.apply((IAction)new ActionAddChemplantRecipe(index, name, inputItems, inputFluids, inputAmounts, outputItems, outputFluids, outputAmounts, duration));
    }

    @ZenMethod
    public static void removeChemplantRecipe(int index) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveChemplantRecipe(index));
    }

    private static class ActionRemoveChemplantRecipe
    implements IAction {
        private int index;

        public ActionRemoveChemplantRecipe(int index) {
            this.index = index;
        }

        public void apply() {
            ChemplantRecipes.removeRecipe(this.index);
        }

        public String describe() {
            return "Removing NTM Chemplant recipe (" + this.index + ")";
        }
    }

    private static class ActionAddChemplantRecipe
    implements IAction {
        private int index;
        private String name;
        private ItemStack[] inputItems;
        private String[] inputFluids;
        private Integer[] inputAmounts;
        private String[] outputFluids;
        private Integer[] outputAmounts;
        private ItemStack[] outputItems;
        private int duration;

        public ActionAddChemplantRecipe(int index, String name, IItemStack[] inputItems, String[] inputFluids, Integer[] inputAmounts, IItemStack[] outputItems, String[] outputFluids, Integer[] outputAmounts, int duration) {
            int i;
            this.index = index;
            this.name = name;
            if (inputItems != null) {
                this.inputItems = new ItemStack[Math.min(4, inputItems.length)];
                for (i = 0; i < Math.min(4, inputItems.length); ++i) {
                    this.inputItems[i] = CraftTweakerMC.getItemStack((IItemStack)inputItems[i]);
                }
            } else {
                this.inputItems = null;
            }
            this.inputFluids = inputFluids;
            this.inputAmounts = inputAmounts;
            this.outputFluids = outputFluids;
            this.outputAmounts = outputAmounts;
            if (outputItems != null) {
                this.outputItems = new ItemStack[Math.min(4, outputItems.length)];
                for (i = 0; i < Math.min(4, outputItems.length); ++i) {
                    this.outputItems[i] = CraftTweakerMC.getItemStack((IItemStack)outputItems[i]);
                }
            } else {
                this.outputItems = null;
            }
            this.duration = duration;
        }

        private boolean checkFluidArray(String[] fluids, Integer[] amounts) {
            if (fluids == null || amounts == null) {
                CraftTweakerAPI.logInfo((String)"ERROR Fluid arrays can not be null/empty!");
                return false;
            }
            if (fluids.length != amounts.length) {
                CraftTweakerAPI.logInfo((String)"ERROR Fluid arrays must have the same length!");
                return false;
            }
            if (fluids.length == 0 || fluids.length > 2) {
                CraftTweakerAPI.logInfo((String)"ERROR Fluid arrays must have a length of 1-2!");
                return false;
            }
            for (int i = 0; i < fluids.length; ++i) {
                if (this.checkFluid(fluids[i], amounts[i])) continue;
                return false;
            }
            return true;
        }

        private boolean checkFluid(String fluid, Integer amount) {
            if (fluid == null || fluid.trim().isEmpty()) {
                CraftTweakerAPI.logInfo((String)"ERROR Fluid can not be null/empty!");
                return false;
            }
            if (!FluidRegistry.isFluidRegistered((String)fluid)) {
                CraftTweakerAPI.logInfo((String)("ERROR Fluid (" + fluid + ") does not exist!"));
                return false;
            }
            if (amount < 1) {
                CraftTweakerAPI.logInfo((String)"ERROR Fluid Amount can not be < 1!");
                return false;
            }
            if (amount > 32000) {
                CraftTweakerAPI.logInfo((String)"ERROR Fluid Amount can not be > 32000!");
                return false;
            }
            return true;
        }

        public void apply() {
            if (this.name == null || this.name.trim().isEmpty()) {
                CraftTweakerAPI.logInfo((String)"ERROR Chemplant Recipe name can not be null/empty!");
                return;
            }
            if (this.inputItems == null && this.inputFluids == null) {
                CraftTweakerAPI.logInfo((String)"ERROR Chemplant Recipe must have inputs");
                return;
            }
            if (this.outputItems == null && this.outputFluids == null) {
                CraftTweakerAPI.logInfo((String)"ERROR Chemplant Recipe must have outputs");
                return;
            }
            if (this.inputFluids == null && this.outputFluids == null) {
                CraftTweakerAPI.logInfo((String)"ERROR Chemplant Recipe must use fluids");
                return;
            }
            if (this.inputFluids != null && this.inputAmounts != null && !this.checkFluidArray(this.inputFluids, this.inputAmounts)) {
                CraftTweakerAPI.logInfo((String)"ERROR Chemplant Recipe must have correct input fluids");
                return;
            }
            if (this.outputFluids != null && this.outputAmounts != null && !this.checkFluidArray(this.outputFluids, this.outputAmounts)) {
                CraftTweakerAPI.logInfo((String)"ERROR Chemplant Recipe must have correct output fluids");
                return;
            }
            if (this.duration < 1) {
                CraftTweakerAPI.logInfo((String)("ERROR Chemplant recipe duraction must be >=1 not " + this.duration + "!"));
                return;
            }
            ChemplantRecipes.makeRecipe(this.index, this.name, this.convertToCom(this.inputItems), this.convertToFlu(this.inputFluids, this.inputAmounts), this.convertToCom(this.outputItems), this.convertToFlu(this.outputFluids, this.outputAmounts), this.duration);
        }

        public FluidStack[] convertToFlu(String[] fluids, Integer[] amounts) {
            if (fluids == null || fluids.length == 0 || amounts == null || amounts.length == 0 || fluids.length != amounts.length) {
                return null;
            }
            FluidStack[] flu = new FluidStack[Math.min(2, fluids.length)];
            for (int i = 0; i < Math.min(2, fluids.length); ++i) {
                flu[i] = new FluidStack(FluidRegistry.getFluid((String)fluids[i]), amounts[i].intValue());
            }
            return flu;
        }

        public RecipesCommon.ComparableStack[] convertToCom(ItemStack[] inputs) {
            if (inputs == null || inputs.length == 0) {
                return null;
            }
            RecipesCommon.ComparableStack[] compInputs = new RecipesCommon.ComparableStack[Math.min(4, inputs.length)];
            for (int i = 0; i < Math.min(4, inputs.length); ++i) {
                compInputs[i] = new RecipesCommon.ComparableStack(inputs[i]);
            }
            return compInputs;
        }

        public String describe() {
            return "Adding NTM chemplant recipe (" + this.index + " " + this.name + " " + this.convertToCom(this.inputItems) + " " + this.convertToFlu(this.inputFluids, this.inputAmounts) + " " + this.convertToCom(this.outputItems) + " " + this.convertToFlu(this.inputFluids, this.inputAmounts) + ")";
        }
    }
}

