/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.config.MobConfig;
import com.hbm.entity.mob.EntityFBI;
import com.hbm.entity.mob.EntityMaskMan;
import com.hbm.entity.mob.EntityRADBeast;
import com.hbm.entity.projectile.EntityMeteor;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.ContaminationUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BossSpawnHandler {
    public static int meteorShower = 0;

    public static void rollTheDice(World world) {
        double spawnY;
        double spawnZ;
        double spawnX;
        int i;
        EntityPlayer player;
        if (MobConfig.enableMaskman && world.func_82737_E() % (long)MobConfig.maskmanDelay == 0L && world.field_73012_v.nextInt(MobConfig.maskmanChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d() && ContaminationUtil.getRads((Entity)(player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size())))) >= (float)MobConfig.maskmanMinRad && ((double)world.func_189649_b((int)player.field_70165_t, (int)player.field_70161_v) > player.field_70163_u + 3.0 || !MobConfig.maskmanUnderground)) {
            player.func_145747_a(new TextComponentString("The mask man is about to claim another victim.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            double spawnX2 = player.field_70165_t + world.field_73012_v.nextGaussian() * 20.0;
            double spawnZ2 = player.field_70161_v + world.field_73012_v.nextGaussian() * 20.0;
            double spawnY2 = world.func_189649_b((int)spawnX2, (int)spawnZ2);
            BossSpawnHandler.trySpawn(world, (float)spawnX2, (float)spawnY2, (float)spawnZ2, (EntityLiving)new EntityMaskMan(world));
        }
        if (MobConfig.enableRaids && world.func_82737_E() % (long)MobConfig.raidDelay == 0L && world.field_73012_v.nextInt(MobConfig.raidChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d()) {
            player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
            player.func_145747_a(new TextComponentString("FBI, OPEN UP!").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            Vec3 vec = Vec3.createVectorHelper(MobConfig.raidAttackDistance, 0.0, 0.0);
            vec.rotateAroundY((float)Math.PI * 2 * world.field_73012_v.nextFloat());
            for (i = 0; i < MobConfig.raidAmount; ++i) {
                spawnX = player.field_70165_t + vec.xCoord + world.field_73012_v.nextGaussian() * 5.0;
                spawnZ = player.field_70161_v + vec.zCoord + world.field_73012_v.nextGaussian() * 5.0;
                spawnY = world.func_189649_b((int)spawnX, (int)spawnZ);
                BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY, (float)spawnZ, (EntityLiving)new EntityFBI(world));
            }
        }
        if (MobConfig.enableRaids && world.func_82737_E() % (long)MobConfig.raidDelay == 0L && world.field_73012_v.nextInt(MobConfig.raidChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d() && (player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()))).getEntityData().func_74775_l("PlayerPersisted").func_74763_f("fbiMark") < world.func_82737_E()) {
            player.func_145747_a(new TextComponentString("FBI, OPEN UP!").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            Vec3 vec = Vec3.createVectorHelper(MobConfig.raidAttackDistance, 0.0, 0.0);
            vec.rotateAroundY((float)Math.PI * 2 * world.field_73012_v.nextFloat());
            for (i = 0; i < MobConfig.raidAmount; ++i) {
                spawnX = player.field_70165_t + vec.xCoord + world.field_73012_v.nextGaussian() * 5.0;
                spawnZ = player.field_70161_v + vec.zCoord + world.field_73012_v.nextGaussian() * 5.0;
                spawnY = world.func_189649_b((int)spawnX, (int)spawnZ);
                BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY, (float)spawnZ, (EntityLiving)new EntityFBI(world));
            }
        }
        if (MobConfig.enableElementals && world.func_82737_E() % (long)MobConfig.elementalDelay == 0L && world.field_73012_v.nextInt(MobConfig.elementalChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d() && (player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()))).getEntityData().func_74775_l("PlayerPersisted").func_74767_n("radMark")) {
            player.func_145747_a(new TextComponentString("You hear a faint clicking...").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", false);
            Vec3 vec = Vec3.createVectorHelper(MobConfig.raidAttackDistance, 0.0, 0.0);
            for (i = 0; i < MobConfig.elementalAmount; ++i) {
                vec.rotateAroundY((float)Math.PI * 2 * world.field_73012_v.nextFloat());
                spawnX = player.field_70165_t + vec.xCoord + world.field_73012_v.nextGaussian();
                spawnZ = player.field_70161_v + vec.zCoord + world.field_73012_v.nextGaussian();
                spawnY = world.func_189649_b((int)spawnX, (int)spawnZ);
                EntityRADBeast rad = new EntityRADBeast(world);
                if (i == 0) {
                    rad.makeLeader();
                }
                BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY, (float)spawnZ, (EntityLiving)rad);
            }
        }
        if (GeneralConfig.enableMeteorStrikes && !world.field_72995_K) {
            BossSpawnHandler.meteorUpdate(world);
        }
    }

    private static void trySpawn(World world, float x, float y, float z, EntityLiving e) {
        e.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)e, (World)world, (float)x, (float)y, (float)z, null);
        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT) {
            world.func_72838_d((Entity)e);
            ForgeEventFactory.doSpecialSpawn((EntityLiving)e, (World)world, (float)x, (float)y, (float)z, null);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
        }
    }

    public static void markFBI(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.getEntityData().func_74775_l("PlayerPersisted").func_74772_a("fbiMark", player.field_70170_p.func_82737_E() + 24000L);
        }
    }

    private static void meteorUpdate(World world) {
        int dimID = world.field_73011_w.getDimension();
        int dimMeteorShowerChance = BossSpawnHandler.parseOInt(CompatibilityConfig.meteorShowerChance.get(dimID));
        int dimMeteorStrikeChance = BossSpawnHandler.parseOInt(CompatibilityConfig.meteorStrikeChance.get(dimID));
        if (dimMeteorShowerChance > 0 && dimMeteorStrikeChance > 0) {
            EntityPlayer p;
            if (world.field_73012_v.nextInt(meteorShower > 0 ? dimMeteorShowerChance : dimMeteorStrikeChance) == 0 && !world.field_73010_i.isEmpty() && (p = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()))) != null && p.field_71093_bK == 0) {
                ItemStack mod;
                boolean repell = false;
                boolean strike = true;
                ItemStack armor = p.func_184582_a(EntityEquipmentSlot.CHEST);
                if (armor != null && ArmorModHandler.hasMods(armor) && (mod = ArmorModHandler.pryMods(armor)[0]) != null) {
                    if (mod.func_77973_b() == ModItems.protection_charm) {
                        repell = true;
                    }
                    if (mod.func_77973_b() == ModItems.meteor_charm) {
                        strike = false;
                    }
                }
                if (strike) {
                    BossSpawnHandler.spawnMeteorAtPlayer(p, repell);
                }
            }
            if (meteorShower > 0 && --meteorShower == 0 && GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("Ended meteor shower.");
            }
            if (world.field_73012_v.nextInt(dimMeteorStrikeChance * 100) == 0 && GeneralConfig.enableMeteorShowers) {
                int dimMeteorShowerDuration = BossSpawnHandler.parseOInt(CompatibilityConfig.meteorShowerDuration.get(dimID));
                meteorShower = (int)((double)dimMeteorShowerDuration * (0.75 + 0.25 * (double)world.field_73012_v.nextFloat()));
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("Started meteor shower! Duration: " + meteorShower);
                }
            }
        }
    }

    public static void spawnMeteorAtPlayer(EntityPlayer p, boolean repell) {
        EntityMeteor meteor = new EntityMeteor(p.field_70170_p);
        meteor.field_70165_t = p.field_70165_t + (double)p.field_70170_p.field_73012_v.nextInt(201) - 100.0;
        meteor.field_70163_u = 384.0;
        meteor.field_70161_v = p.field_70161_v + (double)p.field_70170_p.field_73012_v.nextInt(201) - 100.0;
        if (!repell) {
            meteor.field_70159_w = p.field_70170_p.field_73012_v.nextDouble() - 0.5;
            meteor.field_70179_y = p.field_70170_p.field_73012_v.nextDouble() - 0.5;
        } else {
            meteor.field_70159_w = (p.field_70170_p.field_73012_v.nextDouble() - 0.5) * 3.0;
            meteor.field_70179_y = (p.field_70170_p.field_73012_v.nextDouble() - 0.5) * 3.0;
        }
        meteor.field_70181_x = -10.0;
        meteor.safe = repell;
        p.field_70170_p.func_72838_d((Entity)meteor);
    }

    private static int parseOInt(Object o) {
        if (o == null) {
            return 0;
        }
        return (Integer)o;
    }
}

