/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.config.CompatibilityConfig;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ExplosionNukeRayBatched {
    public HashMap<ChunkPos, List<FloatTriplet>> perChunk = new HashMap();
    public List<ChunkPos> orderedChunks = new ArrayList<ChunkPos>();
    private CoordComparator comparator = new CoordComparator();
    public boolean isContained = true;
    int posX;
    int posY;
    int posZ;
    World world;
    int strength;
    int radius;
    int gspNumMax;
    int gspNum;
    double gspX;
    double gspY;
    private static final int maxY = 255;
    private static final int minY = 0;
    public boolean isAusf3Complete = false;

    public ExplosionNukeRayBatched(World world, int x, int y, int z, int strength, int radius) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.radius = radius;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.gspX = Math.PI;
        this.gspY = 0.0;
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.gspX = Math.acos(hk);
            double prev_lon = this.gspY;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.gspY = lon % (Math.PI * 2);
        } else {
            this.gspX = 0.0;
            this.gspY = 0.0;
        }
        ++this.gspNum;
    }

    private Vec3 getSpherical2cartesian() {
        double dx = Math.sin(this.gspX) * Math.cos(this.gspY);
        double dz = Math.sin(this.gspX) * Math.sin(this.gspY);
        double dy = Math.cos(this.gspX);
        return Vec3.createVectorHelper(dx, dy, dz);
    }

    public void collectTip(int count) {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            this.isAusf3Complete = true;
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int rayProcessed = 0;
        double fac = 1.0;
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = this.getSpherical2cartesian();
            int radius = (int)Math.ceil(this.radius);
            float rayStrength = (float)this.strength * 0.3f;
            FloatTriplet lastPos = null;
            HashSet<ChunkPos> chunkCoords = new HashSet<ChunkPos>();
            for (int r = 0; r < radius + 1; ++r) {
                float x0 = (float)((double)this.posX + vec.xCoord * (double)r);
                float y0 = (float)((double)this.posY + vec.yCoord * (double)r);
                float z0 = (float)((double)this.posZ + vec.zCoord * (double)r);
                int iX = (int)Math.floor(x0);
                int iY = (int)Math.floor(y0);
                int iZ = (int)Math.floor(z0);
                if (iY < 0 || iY > 255) {
                    if (!this.isContained) break;
                    this.isContained = false;
                    break;
                }
                pos.func_181079_c(iX, iY, iZ);
                IBlockState blockState = this.world.func_180495_p((BlockPos)pos);
                if (blockState.func_177230_c().func_149638_a(null) >= 2000000.0f) break;
                fac = 3.0 * (double)r / (double)radius;
                if (!((rayStrength = (float)((double)rayStrength - (Math.pow(ExplosionNukeRayBatched.getNukeResistance(blockState) + 1.0f, fac) - 1.0))) > 0.0f)) break;
                lastPos = new FloatTriplet(x0, y0, z0);
                if (blockState.func_177230_c() != Blocks.field_150350_a) {
                    ChunkPos chunkPos = new ChunkPos(iX >> 4, iZ >> 4);
                    chunkCoords.add(chunkPos);
                }
                if (!this.isContained || r != radius) continue;
                this.isContained = false;
            }
            for (ChunkPos cPos : chunkCoords) {
                List<FloatTriplet> triplets = this.perChunk.get(cPos);
                if (triplets == null) {
                    triplets = new ArrayList<FloatTriplet>();
                    this.perChunk.put(cPos, triplets);
                }
                triplets.add(lastPos);
            }
            this.generateGspUp();
            if (++rayProcessed < count) continue;
            return;
        }
        this.orderedChunks.addAll(this.perChunk.keySet());
        this.orderedChunks.sort(this.comparator);
        this.isAusf3Complete = true;
    }

    public static float getNukeResistance(IBlockState blockState) {
        if (blockState.func_185904_a().func_76224_d()) {
            return 0.1f;
        }
        if (blockState.func_177230_c() == Blocks.field_150322_A) {
            return 4.0f;
        }
        if (blockState.func_177230_c() == Blocks.field_150343_Z) {
            return 18.0f;
        }
        return blockState.func_177230_c().func_149638_a(null);
    }

    public void processChunk() {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            this.perChunk.clear();
        }
        if (this.perChunk.isEmpty()) {
            return;
        }
        ChunkPos coord = this.orderedChunks.get(0);
        List<FloatTriplet> list = this.perChunk.get(coord);
        HashSet<BlockPos> toRem = new HashSet<BlockPos>();
        int chunkX = coord.func_180334_c() >> 4;
        int chunkZ = coord.func_180333_d() >> 4;
        int enter = Math.min(Math.abs(this.posX - (chunkX << 4)), Math.abs(this.posZ - (chunkZ << 4))) - 16;
        enter = Math.max(enter, 0);
        block0: for (FloatTriplet triplet : list) {
            float x = triplet.xCoord;
            float y = triplet.yCoord;
            float z = triplet.zCoord;
            Vec3 vec = Vec3.createVectorHelper(x - (float)this.posX, y - (float)this.posY, z - (float)this.posZ);
            double vLen = vec.lengthVector();
            double pX = vec.xCoord / vLen;
            double pY = vec.yCoord / vLen;
            double pZ = vec.zCoord / vLen;
            boolean inChunk = false;
            int i = enter;
            while ((double)i < vLen) {
                int x0 = (int)Math.floor((double)this.posX + pX * (double)i);
                int y0 = (int)Math.floor((double)this.posY + pY * (double)i);
                int z0 = (int)Math.floor((double)this.posZ + pZ * (double)i);
                if (x0 >> 4 != chunkX || z0 >> 4 != chunkZ) {
                    if (inChunk) {
                        continue block0;
                    }
                } else {
                    inChunk = true;
                    if (this.world.func_180495_p(new BlockPos(x0, y0, z0)).func_177230_c() != Blocks.field_150350_a) {
                        toRem.add(new BlockPos(x0, y0, z0));
                    }
                }
                ++i;
            }
        }
        for (BlockPos pos : toRem) {
            this.world.func_175698_g(pos);
        }
        this.perChunk.remove(coord);
        this.orderedChunks.remove(0);
    }

    public class FloatTriplet {
        public float xCoord;
        public float yCoord;
        public float zCoord;

        public FloatTriplet(float x, float y, float z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }
    }

    public class CoordComparator
    implements Comparator<ChunkPos> {
        @Override
        public int compare(ChunkPos o1, ChunkPos o2) {
            int diff2;
            int chunkX = ExplosionNukeRayBatched.this.posX >> 4;
            int chunkZ = ExplosionNukeRayBatched.this.posZ >> 4;
            int diff1 = Math.abs(chunkX - (o1.func_180334_c() >> 4)) + Math.abs(chunkZ - (o1.func_180333_d() >> 4));
            return diff1 > (diff2 = Math.abs(chunkX - (o2.func_180334_c() >> 4)) + Math.abs(chunkZ - (o2.func_180333_d() >> 4))) ? 1 : (diff1 < diff2 ? -1 : 0);
        }
    }
}

