/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.google.common.collect.Lists;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.CompatibilityConfig;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionNT
extends Explosion {
    public Set<ExAttrib> atttributes = new HashSet<ExAttrib>();
    private Random explosionRNG = new Random();
    private World worldObj;
    protected int field_77289_h = 16;
    protected Map affectedEntities = new HashMap();
    public float explosionSize;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity field_77283_e;
    public final List<BlockPos> field_77281_g;
    public static final List<ExAttrib> nukeAttribs = Arrays.asList(ExAttrib.FIRE, ExAttrib.NOPARTICLE, ExAttrib.NOSOUND, ExAttrib.NODROP, ExAttrib.NOHURT);

    public ExplosionNT(World world, Entity exploder, double x, double y, double z, float strength) {
        super(world, exploder, x, y, z, strength, false, true);
        this.worldObj = world;
        this.explosionSize = strength;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.field_77283_e = exploder;
        this.field_77281_g = Lists.newArrayList();
    }

    public ExplosionNT addAttrib(ExAttrib attrib) {
        this.atttributes.add(attrib);
        return this;
    }

    public ExplosionNT addAllAttrib(List<ExAttrib> attrib) {
        this.atttributes.addAll(attrib);
        return this;
    }

    public ExplosionNT overrideResolution(int res) {
        this.field_77289_h = res;
        return this;
    }

    public void explode() {
        if (CompatibilityConfig.isWarDim(this.worldObj)) {
            this.doNTExplosionA();
            this.doNTExplosionB(false);
        }
    }

    private void doNTExplosionA() {
        double d7;
        double d6;
        double d5;
        int k;
        int j;
        int i;
        float f = this.explosionSize;
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        for (i = 0; i < this.field_77289_h; ++i) {
            for (j = 0; j < this.field_77289_h; ++j) {
                for (k = 0; k < this.field_77289_h; ++k) {
                    if (i != 0 && i != this.field_77289_h - 1 && j != 0 && j != this.field_77289_h - 1 && k != 0 && k != this.field_77289_h - 1) continue;
                    double d0 = (float)i / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    d5 = this.explosionX;
                    d6 = this.explosionY;
                    d7 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int l1;
                        int k1;
                        int j1 = MathHelper.func_76128_c((double)d5);
                        BlockPos pos = new BlockPos(j1, k1 = MathHelper.func_76128_c((double)d6), l1 = MathHelper.func_76128_c((double)d7));
                        IBlockState block = this.worldObj.func_180495_p(pos);
                        if (block.func_185904_a() != Material.field_151579_a) {
                            float f3 = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.worldObj, new BlockPos(j1, k1, l1), block) : block.func_177230_c().getExplosionResistance(this.worldObj, new BlockPos(j1, k1, l1), (Entity)null, (Explosion)this);
                            f1 -= (f3 + 0.3f) * f2;
                        }
                        if (f1 > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, this.worldObj, new BlockPos(j1, k1, l1), block, f1))) {
                            hashset.add(new BlockPos(j1, k1, l1));
                        }
                        d5 += d0 * (double)f2;
                        d6 += d1 * (double)f2;
                        d7 += d2 * (double)f2;
                    }
                }
            }
        }
        this.field_77281_g.addAll(hashset);
        if (!this.has(ExAttrib.NOHURT)) {
            this.explosionSize *= 2.0f;
            i = MathHelper.func_76128_c((double)(this.explosionX - (double)this.explosionSize - 1.0));
            j = MathHelper.func_76128_c((double)(this.explosionX + (double)this.explosionSize + 1.0));
            k = MathHelper.func_76128_c((double)(this.explosionY - (double)this.explosionSize - 1.0));
            int i2 = MathHelper.func_76128_c((double)(this.explosionY + (double)this.explosionSize + 1.0));
            int l = MathHelper.func_76128_c((double)(this.explosionZ - (double)this.explosionSize - 1.0));
            int j2 = MathHelper.func_76128_c((double)(this.explosionZ + (double)this.explosionSize + 1.0));
            List list = this.worldObj.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
            ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)this.explosionSize);
            Vec3 vec3 = Vec3.createVectorHelper(this.explosionX, this.explosionY, this.explosionZ);
            for (int i1 = 0; i1 < list.size(); ++i1) {
                double d9;
                Entity entity = (Entity)list.get(i1);
                double d4 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
                if (!(d4 <= 1.0) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.explosionX) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY) * d6 + (d7 = entity.field_70161_v - this.explosionZ) * d7))) == 0.0) continue;
                d5 /= d9;
                d6 /= d9;
                d7 /= d9;
                double d10 = this.worldObj.func_72842_a(new Vec3d(vec3.xCoord, vec3.yCoord, vec3.zCoord), entity.func_174813_aQ());
                double d11 = (1.0 - d4) * d10;
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d11 * d11 + d11) / 2.0 * 8.0 * (double)this.explosionSize + 1.0)));
                double d8 = d11;
                if (entity instanceof EntityLivingBase) {
                    d8 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d11);
                }
                entity.field_70159_w += d5 * d8;
                entity.field_70181_x += d6 * d8;
                entity.field_70179_y += d7 * d8;
                if (!(entity instanceof EntityPlayer)) continue;
                this.affectedEntities.put((EntityPlayer)entity, Vec3.createVectorHelper(d5 * d11, d6 * d11, d7 * d11));
            }
            this.explosionSize = f;
        }
    }

    private void doNTExplosionB(boolean p_77279_1_) {
        IBlockState block;
        int k;
        int j;
        int i;
        if (!this.has(ExAttrib.NOSOUND)) {
            this.worldObj.func_184148_a(null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (!this.has(ExAttrib.NOPARTICLE)) {
            if (this.explosionSize >= 2.0f) {
                this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
            } else {
                this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
            }
        }
        for (BlockPos chunkposition : this.field_77281_g) {
            i = chunkposition.func_177958_n();
            j = chunkposition.func_177956_o();
            k = chunkposition.func_177952_p();
            block = this.worldObj.func_180495_p(chunkposition);
            if (!this.has(ExAttrib.NOPARTICLE)) {
                double d0 = (float)i + this.worldObj.field_73012_v.nextFloat();
                double d1 = (float)j + this.worldObj.field_73012_v.nextFloat();
                double d2 = (float)k + this.worldObj.field_73012_v.nextFloat();
                double d3 = d0 - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
            if (block.func_185904_a() == Material.field_151579_a) continue;
            if (block.func_177230_c().func_149659_a((Explosion)this) && !this.has(ExAttrib.NODROP)) {
                float chance = 1.0f;
                if (!this.has(ExAttrib.ALLDROP)) {
                    chance = 1.0f / this.explosionSize;
                }
                block.func_177230_c().func_180653_a(this.worldObj, chunkposition, this.worldObj.func_180495_p(chunkposition), chance, 0);
            }
            block.func_177230_c().onBlockExploded(this.worldObj, new BlockPos(i, j, k), (Explosion)this);
            if (!block.func_185915_l()) continue;
            if (this.has(ExAttrib.DIGAMMA)) {
                this.worldObj.func_175656_a(new BlockPos(i, j, k), ModBlocks.ash_digamma.func_176223_P());
                if (this.explosionRNG.nextInt(5) != 0 || this.worldObj.func_180495_p(new BlockPos(i, j + 1, k)).func_177230_c() != Blocks.field_150350_a) continue;
                this.worldObj.func_175656_a(new BlockPos(i, j + 1, k), ModBlocks.fire_digamma.func_176223_P());
                continue;
            }
            if (this.has(ExAttrib.DIGAMMA_CIRCUIT)) {
                if (i % 3 == 0 && k % 3 == 0) {
                    this.worldObj.func_175656_a(new BlockPos(i, j, k), ModBlocks.pribris_digamma.func_176223_P());
                    continue;
                }
                if ((i % 3 == 0 || k % 3 == 0) && this.explosionRNG.nextBoolean()) {
                    this.worldObj.func_175656_a(new BlockPos(i, j, k), ModBlocks.pribris_digamma.func_176223_P());
                    continue;
                }
                this.worldObj.func_175656_a(new BlockPos(i, j, k), ModBlocks.ash_digamma.func_176223_P());
                if (this.explosionRNG.nextInt(5) != 0 || this.worldObj.func_180495_p(new BlockPos(i, j + 1, k)).func_177230_c() != Blocks.field_150350_a) continue;
                this.worldObj.func_175656_a(new BlockPos(i, j + 1, k), ModBlocks.fire_digamma.func_176223_P());
                continue;
            }
            if (!this.has(ExAttrib.LAVA_V)) continue;
            this.worldObj.func_175656_a(new BlockPos(i, j, k), ModBlocks.volcanic_lava_block.func_176223_P());
        }
        if (this.has(ExAttrib.FIRE) || this.has(ExAttrib.BALEFIRE) || this.has(ExAttrib.LAVA)) {
            for (BlockPos chunkposition : this.field_77281_g) {
                i = chunkposition.func_177958_n();
                j = chunkposition.func_177956_o();
                k = chunkposition.func_177952_p();
                block = this.worldObj.func_180495_p(chunkposition);
                IBlockState block1 = this.worldObj.func_180495_p(new BlockPos(i, j - 1, k));
                boolean shouldReplace = true;
                if (!this.has(ExAttrib.ALLMOD)) {
                    boolean bl = shouldReplace = this.explosionRNG.nextInt(3) == 0;
                }
                if (block.func_185904_a() != Material.field_151579_a || !block1.func_185913_b() || !shouldReplace) continue;
                if (this.has(ExAttrib.FIRE)) {
                    this.worldObj.func_175656_a(chunkposition, Blocks.field_150480_ab.func_176223_P());
                    continue;
                }
                if (this.has(ExAttrib.BALEFIRE)) {
                    this.worldObj.func_175656_a(chunkposition, ModBlocks.balefire.func_176223_P());
                    continue;
                }
                if (!this.has(ExAttrib.LAVA)) continue;
                this.worldObj.func_175656_a(chunkposition, Blocks.field_150356_k.func_176223_P());
            }
        }
    }

    public Map func_77277_b() {
        return this.affectedEntities;
    }

    public EntityLivingBase func_94613_c() {
        return this.field_77283_e == null ? null : (this.field_77283_e instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.field_77283_e).func_94083_c() : (this.field_77283_e instanceof EntityLivingBase ? (EntityLivingBase)this.field_77283_e : null));
    }

    public boolean has(ExAttrib attrib) {
        return this.atttributes.contains((Object)attrib);
    }

    public static enum ExAttrib {
        FIRE,
        BALEFIRE,
        DIGAMMA,
        DIGAMMA_CIRCUIT,
        LAVA,
        LAVA_V,
        ALLMOD,
        ALLDROP,
        NODROP,
        NOPARTICLE,
        NOSOUND,
        NOHURT;

    }
}

