/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.core;

import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class FramebufferClassTransformer
implements IClassTransformer {
    private static final String[] classesBeingTransformed = new String[]{"net.minecraft.client.shader.Framebuffer"};

    public byte[] transform(String name, String transformedName, byte[] classBeingTransformed) {
        boolean isObfuscated = !name.equals(transformedName);
        int index = Arrays.asList(classesBeingTransformed).indexOf(transformedName);
        return index != -1 ? FramebufferClassTransformer.transform(index, classBeingTransformed, isObfuscated) : classBeingTransformed;
    }

    private static byte[] transform(int index, byte[] classBeingTransformed, boolean isObfuscated) {
        System.out.println("Transforming: " + classesBeingTransformed[index]);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBeingTransformed);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (index) {
                case 0: {
                    FramebufferClassTransformer.transformFramebuffer(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return classBeingTransformed;
        }
    }

    private static void transformFramebuffer(ClassNode clazz, boolean isObfuscated) {
        for (MethodNode method : clazz.methods) {
            if (!method.name.equals("createFramebuffer") && !method.name.equals("func_147605_b")) continue;
            for (int i = 0; i < method.instructions.toArray().length; ++i) {
                AbstractInsnNode node;
                AbstractInsnNode m = method.instructions.get(i);
                if (!(m instanceof MethodInsnNode)) continue;
                MethodInsnNode m2 = (MethodInsnNode)m;
                if (!m2.name.equals("glTexImage2D") || !((node = method.instructions.get(i - 10)) instanceof LdcInsnNode)) continue;
                LdcInsnNode rgba_8 = (LdcInsnNode)node;
                if (!(rgba_8.cst instanceof Integer) || (Integer)rgba_8.cst != 32856) continue;
                rgba_8.cst = 32859;
            }
        }
    }
}

