/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.main.MainRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;

public class JsonConfig {
    public static final Gson gson = new Gson();

    private static File getFile(String filename) {
        return new File(MainRegistry.proxy.getDataDir().getPath() + "/config/hbm" + File.separatorChar + filename);
    }

    public static JsonWriter startWriting(String filename) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(JsonConfig.getFile(filename)));
            writer.setIndent("  ");
            writer.beginObject();
            return writer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void stopWriting(JsonWriter writer) {
        try {
            writer.endObject();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JsonObject startReading(String filename) {
        try {
            File file = JsonConfig.getFile(filename);
            if (file.exists()) {
                return (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

