/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.command;

import com.google.common.collect.Lists;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.main.ModEventHandlerClient;
import com.hbm.main.ResourceManager;
import com.hbm.render.GLCompat;
import com.hbm.world.Antenna;
import com.hbm.world.Barrel;
import com.hbm.world.Bunker;
import com.hbm.world.CrashedVertibird;
import com.hbm.world.DesertAtom001;
import com.hbm.world.Dud;
import com.hbm.world.Factory;
import com.hbm.world.Geyser;
import com.hbm.world.GeyserLarge;
import com.hbm.world.LibraryDungeon;
import com.hbm.world.Radio01;
import com.hbm.world.Relay;
import com.hbm.world.Satellite;
import com.hbm.world.Sellafield;
import com.hbm.world.Silo;
import com.hbm.world.Spaceship;
import com.hbm.world.Vertibird;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class CommandHbm
extends CommandBase {
    public String func_71517_b() {
        return "hbm";
    }

    public String func_71518_a(ICommandSender sender) {
        return "[WIP] Usage: /hbm <subcommand> <args>\nDo /hbm subcommands for a list of subcommands";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return this.getSubCommands().stream().filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if ("subcommands".equals(args[0])) {
                return Lists.newArrayList((Object[])new String[]{"gen"}).stream().filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
            }
            if ("gen".equals(args[0])) {
                return Lists.newArrayList((Object[])new String[]{"antenna", "relay", "dud", "silo", "factory", "barrel", "vertibird", "vertibird_crashed", "satellite", "spaceship", "sellafield", "radio", "bunker", "desert_atom", "library", "geysir_water", "geysir_vapor", "geysir_chlorine"}).stream().filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length > 0) {
            if ("subcommands".equals(args[0])) {
                this.doSubcommandCommand(server, sender, args);
                return;
            }
            if ("gen".equals(args[0])) {
                this.doGenCommand(server, sender, args);
                return;
            }
            if ("reloadCollada".equals(args[0])) {
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        ResourceManager.loadAnimatedModels();
                        ResourceManager.lit_particles = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lit_particles"), shader -> {
                            GLCompat.bindAttribLocation(shader, 0, "pos");
                            GLCompat.bindAttribLocation(shader, 1, "offsetPos");
                            GLCompat.bindAttribLocation(shader, 2, "scale");
                            GLCompat.bindAttribLocation(shader, 3, "texData");
                            GLCompat.bindAttribLocation(shader, 4, "color");
                            GLCompat.bindAttribLocation(shader, 5, "lightmap");
                        }).withUniforms(HbmShaderManager2.MODELVIEW_MATRIX, HbmShaderManager2.PROJECTION_MATRIX, HbmShaderManager2.INV_PLAYER_ROT_MATRIX, HbmShaderManager2.LIGHTMAP);
                        ResourceManager.gluon_beam = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/gluon_beam")).withUniforms(shader -> {
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 3);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_1);
                            shader.uniform1i("noise_1", 3);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 4);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise_1", 4);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0);
                            float time = (float)(System.currentTimeMillis() % 10000000L) / 1000.0f;
                            shader.uniform1f("time", time);
                        });
                        ResourceManager.gluon_spiral = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/gluon_spiral")).withUniforms(shader -> {
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 3);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_1);
                            shader.uniform1i("noise_1", 3);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 4);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise_1", 4);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0);
                            float time = (float)(System.currentTimeMillis() % 10000000L) / 1000.0f;
                            shader.uniform1f("time", time);
                        });
                        ResourceManager.tau_ray = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/tau_ray"));
                        ResourceManager.book_circle = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/book/circle"));
                        ResourceManager.normal_fadeout = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/normal_fadeout"));
                        ResourceManager.heat_distortion = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/heat_distortion")).withUniforms(shader -> {
                            Framebuffer buffer = Minecraft.func_71410_x().func_147110_a();
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 3);
                            GlStateManager.func_179144_i((int)buffer.field_147617_g);
                            shader.uniform1i("fbo_tex", 3);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 4);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise", 4);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0);
                            float time = (float)(System.currentTimeMillis() % 10000000L) / 1000.0f;
                            shader.uniform1f("time", time);
                            shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                        });
                        ResourceManager.desaturate = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/desaturate"));
                        ResourceManager.test_trail = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/trail"), shader -> {
                            GLCompat.bindAttribLocation(shader, 0, "pos");
                            GLCompat.bindAttribLocation(shader, 1, "tex");
                            GLCompat.bindAttribLocation(shader, 2, "color");
                        });
                        ResourceManager.blit = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/blit"));
                        ResourceManager.downsample = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/downsample"));
                        ResourceManager.bloom_h = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/bloom_h"));
                        ResourceManager.bloom_v = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/bloom_v"));
                        ResourceManager.bloom_test = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/bloom_test"));
                        ResourceManager.lightning = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lightning"), shader -> {
                            GLCompat.bindAttribLocation(shader, 0, "pos");
                            GLCompat.bindAttribLocation(shader, 1, "tex");
                            GLCompat.bindAttribLocation(shader, 2, "color");
                        }).withUniforms(shader -> {
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 4);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise", 4);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0);
                        });
                        ResourceManager.maxdepth = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/maxdepth"));
                        ResourceManager.lightning_gib = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lightning_gib")).withUniforms(HbmShaderManager2.LIGHTMAP, shader -> {
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 4);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise", 4);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0);
                        });
                        ResourceManager.testlut = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/testlut"));
                        ResourceManager.flashlight_nogeo = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/flashlight_nogeo"));
                        ResourceManager.flashlight_deferred = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/flashlight_deferred")).withUniforms(shader -> shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                        ResourceManager.albedo = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/albedo"));
                        ResourceManager.flashlight_depth = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/flashlight_depth"));
                        ResourceManager.flashlight_post = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/flashlight_post")).withUniforms(shader -> shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                        ResourceManager.pointlight_post = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/pointlight_post")).withUniforms(shader -> shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                        ResourceManager.cone_volume = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/cone_volume")).withUniforms(shader -> shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                        ResourceManager.flashlight_blit = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/blit"));
                        ResourceManager.volume_upscale = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/lighting/volume_upscale")).withUniforms(shader -> shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                        ResourceManager.heat_distortion_post = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/heat_distortion_post")).withUniforms(shader -> {
                            shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                            GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 4));
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise", 4);
                            GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
                            float time = (float)(System.currentTimeMillis() % 10000000L) / 1000.0f;
                            shader.uniform1f("time", time);
                        });
                        ResourceManager.heat_distortion_new = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/heat_distortion_new"));
                        ResourceManager.crucible_lightning = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/crucible_lightning"), shader -> {
                            GLCompat.bindAttribLocation(shader, 0, "pos");
                            GLCompat.bindAttribLocation(shader, 1, "tex");
                            GLCompat.bindAttribLocation(shader, 2, "in_color");
                        }).withUniforms(shader -> {
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 4);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
                            shader.uniform1i("noise", 4);
                            GLCompat.activeTexture(GLCompat.GL_TEXTURE0);
                        });
                        ResourceManager.flash_lmap = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/flash_lmap")).withUniforms(HbmShaderManager2.LIGHTMAP);
                        ResourceManager.bimpact = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/bimpact"), shader -> {
                            GLCompat.bindAttribLocation(shader, 0, "pos");
                            GLCompat.bindAttribLocation(shader, 1, "vColor");
                            GLCompat.bindAttribLocation(shader, 3, "tex");
                            GLCompat.bindAttribLocation(shader, 4, "lightTex");
                            GLCompat.bindAttribLocation(shader, 5, "projTex");
                        }).withUniforms(HbmShaderManager2.LIGHTMAP, HbmShaderManager2.WINDOW_SIZE);
                        ResourceManager.blood_dissolve = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/blood/blood")).withUniforms(HbmShaderManager2.LIGHTMAP);
                        ResourceManager.gravitymap_render = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/blood/gravitymap"));
                        ResourceManager.blood_flow_update = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/blood/blood_flow_update"));
                        ResourceManager.gpu_particle_render = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/gpu_particle_render")).withUniforms(HbmShaderManager2.MODELVIEW_MATRIX, HbmShaderManager2.PROJECTION_MATRIX, HbmShaderManager2.INV_PLAYER_ROT_MATRIX, shader -> {
                            shader.uniform1i("lightmap", 1);
                            shader.uniform1i("particleData0", 2);
                            shader.uniform1i("particleData1", 3);
                            shader.uniform1i("particleData2", 4);
                            shader.uniform4f("particleTypeTexCoords[0]", ModEventHandlerClient.contrail.func_94209_e(), ModEventHandlerClient.contrail.func_94206_g(), ModEventHandlerClient.contrail.func_94212_f() - ModEventHandlerClient.contrail.func_94209_e(), ModEventHandlerClient.contrail.func_94210_h() - ModEventHandlerClient.contrail.func_94206_g());
                        });
                        ResourceManager.gpu_particle_udpate = HbmShaderManager2.loadShader(new ResourceLocation("hbm", "shaders/gpu_particle_update")).withUniforms(shader -> {
                            shader.uniform1i("particleData0", 2);
                            shader.uniform1i("particleData1", 3);
                            shader.uniform1i("particleData2", 4);
                        });
                        sender.func_145747_a((ITextComponent)new TextComponentString("Reloaded resources!"));
                    });
                }
                return;
            }
        }
    }

    protected List<String> getSubCommands() {
        return Lists.newArrayList((Object[])new String[]{"subcommands", "gen", "reloadCollada"});
    }

    protected void doSubcommandCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("Hbm command list [DEBUG]\n\n");
            for (String s : this.getSubCommands()) {
                builder.append(s).append("\n");
            }
            builder.delete(builder.length() - 1, builder.length());
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(builder.toString(), new Object[0]));
        } else if (args.length > 1) {
            if ("gen".equals(args[1])) {
                StringBuilder builder = new StringBuilder();
                builder.append("Info for command: gen\n\n");
                builder.append("Generates a structure at the block under your current position. Generation can be forced.\n\n");
                builder.append("Available structures:\n\n");
                builder.append("antenna      relay\ndud           silo\nfactory      barrel\nvertibird     vertibird_crashed\nsatellite      spaceship\nsellafield     radio\nbunker       desert_atom\nlibrary      geysir_water\ngeysir_vapor      geysir_chlorine");
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(builder.toString(), new Object[0]));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Unknown command: " + args[1], new Object[0]));
            }
        }
    }

    protected void doGenCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 1) {
            boolean force = false;
            World world = sender.func_130014_f_();
            Random rand = world.field_73012_v;
            Vec3d senderPos = sender.func_174791_d();
            BlockPos genPos = new BlockPos(senderPos.field_72450_a, (double)world.func_189649_b((int)senderPos.field_72450_a, (int)senderPos.field_72449_c), senderPos.field_72449_c);
            if (args.length > 2 && "f".equals(args[2])) {
                force = true;
            }
            if ("antenna".equals(args[1])) {
                new Antenna().generate(world, rand, genPos, force);
            } else if ("relay".equals(args[1])) {
                new Relay().generate(world, rand, genPos, force);
            } else if ("dud".equals(args[1])) {
                new Dud().generate(world, rand, genPos, force);
            } else if ("silo".equals(args[1])) {
                new Silo().generate(world, rand, genPos, force);
            } else if ("factory".equals(args[1])) {
                new Factory().generate(world, rand, genPos, force);
            } else if ("barrel".equals(args[1])) {
                new Barrel().generate(world, rand, genPos, force);
            } else if ("vertibird".equals(args[1])) {
                new Vertibird().generate(world, rand, genPos, force);
            } else if ("vertibird_crashed".equals(args[1])) {
                new CrashedVertibird().generate(world, rand, genPos, force);
            } else if ("satellite".equals(args[1])) {
                new Satellite().generate(world, rand, genPos, force);
            } else if ("spaceship".equals(args[1])) {
                new Spaceship().generate(world, rand, genPos, force);
            } else if ("sellafield".equals(args[1])) {
                double r = rand.nextInt(15) + 10;
                if (rand.nextInt(50) == 0) {
                    r = 50.0;
                }
                new Sellafield().generate(world, (int)senderPos.field_72450_a, (int)senderPos.field_72449_c, r, r * 0.35);
            } else if ("radio".equals(args[1])) {
                new Radio01().generate(world, rand, genPos, force);
            } else if ("bunker".equals(args[1])) {
                new Bunker().generate(world, rand, genPos, force);
            } else if ("desert_atom".equals(args[1])) {
                new DesertAtom001().generate(world, rand, genPos, force);
            } else if ("library".equals(args[1])) {
                new LibraryDungeon().generate(world, rand, genPos, force);
            } else if ("geysir_water".equals(args[1])) {
                if (force) {
                    new GeyserLarge().func_180709_b(world, rand, genPos);
                } else if (world.func_180495_p(genPos.func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
                    new GeyserLarge().func_180709_b(world, rand, genPos);
                }
            } else if ("geysir_vapor".equals(args[1])) {
                if (force) {
                    world.func_175656_a(genPos.func_177977_b(), ModBlocks.geysir_vapor.func_176223_P());
                } else if (world.func_180495_p(genPos.func_177977_b()).func_177230_c() == Blocks.field_150348_b) {
                    world.func_175656_a(genPos.func_177977_b(), ModBlocks.geysir_vapor.func_176223_P());
                }
            } else if ("geysir_chlorine".equals(args[1])) {
                if (force) {
                    new Geyser().func_180709_b(world, rand, genPos);
                } else if (world.func_180495_p(genPos.func_177977_b()).func_177230_c() == Blocks.field_150349_c) {
                    new Geyser().func_180709_b(world, rand, genPos);
                }
            }
        }
    }
}

