/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.interfaces.IItemHazard;
import com.hbm.main.MainRegistry;
import com.hbm.modules.ItemHazardModule;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ContaminationUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WasteEarth
extends Block
implements IItemHazard {
    public static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)15);
    ItemHazardModule module;

    public WasteEarth(Material materialIn, boolean tick, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(MainRegistry.controlTab);
        this.func_149675_a(tick);
        this.setHarvestLevel("shovel", 0);
        this.module = new ItemHazardModule();
        ModBlocks.ALL_BLOCKS.add(this);
    }

    public WasteEarth(Material materialIn, SoundType type, boolean tick, String s) {
        this(materialIn, tick, s);
        this.func_149672_a(type);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public ItemHazardModule getModule() {
        return this.module;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this == ModBlocks.frozen_grass) {
            return Items.field_151126_ay;
        }
        return Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof EntityLivingBase && this == ModBlocks.waste_earth) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)HbmPotion.radiation, 300, 4));
        }
        if (entity instanceof EntityLivingBase && this == ModBlocks.waste_dirt) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)HbmPotion.radiation, 400, 9));
        }
        if (entity instanceof EntityLivingBase && this == ModBlocks.frozen_grass) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2400, 2));
        }
        if (entity instanceof EntityLivingBase && this == ModBlocks.waste_mycelium) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)HbmPotion.radiation, 600, 29));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (this == ModBlocks.waste_earth || this == ModBlocks.waste_mycelium) {
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return ContaminationUtil.isRadImmune(entityIn);
    }

    public void func_180650_b(World world, BlockPos pos1, IBlockState state, Random rand) {
        int x = pos1.func_177958_n();
        int y = pos1.func_177956_o();
        int z = pos1.func_177952_p();
        if (this == ModBlocks.waste_mycelium && GeneralConfig.enableMycelium) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int k = -1; k < 2; ++k) {
                        Block b0 = world.func_180495_p(new BlockPos(x + i, y + j, z + k)).func_177230_c();
                        IBlockState b1 = world.func_180495_p(new BlockPos(x + i, y + j + 1, z + k));
                        if (b1.func_185914_p() || b0 != Blocks.field_150346_d && b0 != Blocks.field_150349_c && b0 != Blocks.field_150391_bh && b0 != ModBlocks.waste_earth) continue;
                        world.func_175656_a(new BlockPos(x + i, y + j, z + k), ModBlocks.waste_mycelium.func_176223_P());
                    }
                }
            }
        }
        if (this == ModBlocks.waste_earth || this == ModBlocks.waste_dirt || this == ModBlocks.waste_mycelium) {
            if (GeneralConfig.enableAutoCleanup) {
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150346_d.func_176223_P());
            }
            if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c() instanceof BlockMushroom) {
                world.func_175656_a(new BlockPos(x, y + 1, z), ModBlocks.mush.func_176223_P());
            }
        }
    }
}

