/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.BedrockOreRegistry;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;

public class BlockBedrockOreTE
extends BlockContainer
implements ILookOverlay {
    public BlockBedrockOreTE(String s) {
        super(Material.field_151576_e);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBedrockOre("oreIron");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_70015_d(3);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityBedrockOre)) {
            return;
        }
        TileEntityBedrockOre ore = (TileEntityBedrockOre)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(I18nUtil.resolveKey("desc.ore", BedrockOreRegistry.getOreName(ore.oreName)));
        text.add(I18nUtil.resolveKey("desc.tier", ore.tier));
        if (ore.acidRequirement != null) {
            text.add(I18nUtil.resolveKey("desc.requires", ore.acidRequirement.amount, ore.acidRequirement.getFluid().getLocalizedName(ore.acidRequirement)));
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public static class TileEntityBedrockOre
    extends TileEntity {
        public String oreName;
        public int color;
        public int tier;
        public FluidStack acidRequirement;

        public TileEntityBedrockOre() {
        }

        public TileEntityBedrockOre(String oreName) {
            this.oreName = oreName;
            this.color = BedrockOreRegistry.getOreColor(oreName);
            this.tier = BedrockOreRegistry.getOreTier(oreName);
            this.acidRequirement = BedrockOreRegistry.getFluidRequirement(this.tier);
        }

        public TileEntityBedrockOre setOre(String oreName) {
            this.oreName = oreName;
            this.color = BedrockOreRegistry.getOreColor(oreName);
            this.tier = BedrockOreRegistry.getOreTier(oreName);
            this.acidRequirement = BedrockOreRegistry.getFluidRequirement(this.tier);
            this.func_70296_d();
            return this;
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.oreName = nbt.func_74779_i("ore");
            this.tier = nbt.func_74762_e("tier");
            this.color = nbt.func_74762_e("color");
            this.acidRequirement = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            nbt.func_74778_a("ore", this.oreName);
            nbt.func_74768_a("tier", this.tier);
            nbt.func_74768_a("color", this.color);
            if (this.acidRequirement != null) {
                this.acidRequirement.writeToNBT(nbt);
            }
            return nbt;
        }

        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
        }

        public NBTTagCompound func_189517_E_() {
            return this.func_189515_b(new NBTTagCompound());
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }
}

