/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.interfaces.IBomb;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityNukeFleija;
import com.hbm.util.I18nUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class NukeFleija
extends BlockContainer
implements IBomb {
    public static final PropertyInteger FACING = PropertyInteger.func_177719_a((String)"facing", (int)2, (int)5);

    public NukeFleija(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(2)));
        this.func_149647_a(MainRegistry.nukeTab);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNukeFleija();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.nuke_fleija);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityNukeFleija) {
            InventoryHelper.dropInventoryItems(world, pos, (ICapabilityProvider)((TileEntityNukeFleija)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityNukeFleija entity = (TileEntityNukeFleija)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 17, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityNukeFleija entity = (TileEntityNukeFleija)worldIn.func_175625_s(pos);
        if (worldIn.func_175687_A(pos) > 0 && !worldIn.field_72995_K && entity.isReady()) {
            this.func_176206_d(worldIn, pos, state);
            entity.clearSlots();
            worldIn.func_175698_g(pos);
            this.igniteTestBomb(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.fleijaRadius);
        }
    }

    public boolean igniteTestBomb(World world, int x, int y, int z, int r) {
        if (!world.field_72995_K) {
            world.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(world);
            entity.field_70165_t = x;
            entity.field_70163_u = y;
            entity.field_70161_v = z;
            if (!EntityNukeExplosionMK3.isJammed(world, entity)) {
                entity.destructionRange = r;
                entity.speed = BombConfig.blastSpeed;
                entity.coefficient = 1.0f;
                entity.waste = false;
                world.func_72838_d((Entity)entity);
                EntityCloudFleija cloud = new EntityCloudFleija(world, r);
                cloud.field_70165_t = x;
                cloud.field_70163_u = y;
                cloud.field_70161_v = z;
                world.func_72838_d((Entity)cloud);
            }
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(5)), 2);
        }
        if (i == 1) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(3)), 2);
        }
        if (i == 2) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(4)), 2);
        }
        if (i == 3) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(2)), 2);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntityNukeFleija entity = (TileEntityNukeFleija)world.func_175625_s(pos);
        if (entity.isReady()) {
            this.func_176206_d(world, pos, world.func_180495_p(pos));
            entity.clearSlots();
            world.func_175698_g(pos);
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.fleijaRadius);
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)FACING);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= 2 && meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(meta));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(2));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("\u00a7b[" + I18nUtil.resolveKey("trait.schrabbomb", new Object[0]) + "]\u00a7r");
        tooltip.add(" \u00a7e" + I18nUtil.resolveKey("desc.radius", BombConfig.fleijaRadius) + "\u00a7r");
    }
}

