/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.PaginatedScreen;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_327;
import net.minecraft.class_388;

public class ControlsGui
extends PaginatedScreen {
    private static final int maxElementsPerPage = 7;
    private static final int startRow = 1;
    private final Map<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> keyMappings;
    private final Map<String, List<String>> categorizedNames = StringUtils.newHashMap();
    private final Map<Integer, List<Tuple<String, Pair<Float, Float>, Integer>>> preRenderQueue = StringUtils.newHashMap();
    private final Map<Integer, List<Tuple<String, Pair<Float, Float>, Integer>>> postRenderQueue = StringUtils.newHashMap();
    private String backupKeyString;
    private Tuple<ExtendedButtonControl, String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entryData = null;
    private int currentAllocatedRow = 1;
    private int currentAllocatedPage = this.startPage;

    public ControlsGui(class_388 parentScreen) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings();
        this.sortMappings();
    }

    public ControlsGui(class_388 parentScreen, KeyUtils.FilterMode filterMode, List<String> filterData) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings(filterMode, filterData);
        this.sortMappings();
    }

    public ControlsGui(class_388 parentScreen, KeyUtils.FilterMode filterMode, String ... filterData) {
        this(parentScreen, filterMode, StringUtils.newArrayList(filterData));
    }

    @Override
    public void initializeUi() {
        this.setupScreenData();
        super.initializeUi();
        this.backButton.setOnClick(() -> {
            if (this.entryData == null) {
                this.openScreen(this.parentScreen);
            }
        });
    }

    @Override
    public void renderExtra() {
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = Constants.TRANSLATOR.translate("gui.config.message.button.controls", new Object[0]);
        this.renderScrollingString(mainTitle, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
        this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
        super.renderExtra();
        for (Map.Entry<Integer, List<Tuple<String, Pair<Float, Float>, Integer>>> entry : this.preRenderQueue.entrySet()) {
            Integer pageNumber = entry.getKey();
            List<Tuple<String, Pair<Float, Float>, Integer>> elementList = entry.getValue();
            for (Tuple<String, Pair<Float, Float>, Integer> elementData : elementList) {
                this.renderString(Constants.TRANSLATOR.translate(elementData.getFirst(), new Object[0]), elementData.getSecond().getFirst().floatValue(), elementData.getSecond().getSecond().floatValue(), elementData.getThird(), pageNumber);
            }
        }
    }

    @Override
    public void postRender() {
        for (Map.Entry<Integer, List<Tuple<String, Pair<Float, Float>, Integer>>> entry : this.postRenderQueue.entrySet()) {
            Integer pageNumber = entry.getKey();
            List<Tuple<String, Pair<Float, Float>, Integer>> elementList = entry.getValue();
            for (Tuple<String, Pair<Float, Float>, Integer> elementData : elementList) {
                if (this.currentPage != pageNumber || !RenderUtils.isMouseOver(this.getMouseX(), this.getMouseY(), elementData.getSecond().getFirst().floatValue(), elementData.getSecond().getSecond().floatValue(), this.getStringWidth(Constants.TRANSLATOR.translate(elementData.getFirst(), new Object[0])), this.getFontHeight())) continue;
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate(elementData.getFirst().replace(".name", ".description"), new Object[0])));
            }
        }
        super.postRender();
    }

    @Override
    protected void method_1024(char typedChar, int keyCode) {
        if (this.entryData != null) {
            this.setKeyData(keyCode);
        } else {
            super.method_1024(typedChar, keyCode);
        }
    }

    private void sortMappings() {
        for (Map.Entry<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.keyMappings.entrySet()) {
            String keyName = entry.getKey();
            Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = entry.getValue();
            if (!this.categorizedNames.containsKey(keyData.getFirst().method_6620())) {
                this.categorizedNames.put(keyData.getFirst().method_6620(), StringUtils.newArrayList(keyName));
                continue;
            }
            if (this.categorizedNames.get(keyData.getFirst().method_6620()).contains(keyName)) continue;
            this.categorizedNames.get(keyData.getFirst().method_6620()).add(keyName);
        }
    }

    private void setupScreenData() {
        this.preRenderQueue.clear();
        this.postRenderQueue.clear();
        int renderPosition = this.getScreenWidth() / 2 + 3;
        for (Map.Entry<String, List<String>> entry : this.categorizedNames.entrySet()) {
            this.syncPageData();
            String categoryName = entry.getKey();
            Tuple<String, Pair<Float, Float>, Integer> categoryData = new Tuple<String, Pair<Float, Float>, Integer>(categoryName, new Pair<Float, Float>(Float.valueOf((float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(categoryName) / 2.0f), Float.valueOf(this.getButtonY(this.currentAllocatedRow, 5))), 0xFFFFFF);
            if (!this.preRenderQueue.containsKey(this.currentAllocatedPage)) {
                this.preRenderQueue.put(this.currentAllocatedPage, StringUtils.newArrayList());
            }
            if (!Constants.IS_LEGACY_SOFT) {
                this.preRenderQueue.get(this.currentAllocatedPage).add(categoryData);
            }
            List<String> keyNames = entry.getValue();
            ++this.currentAllocatedRow;
            for (String keyName : keyNames) {
                Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = this.keyMappings.get(keyName);
                Tuple<String, Pair<Float, Float>, Integer> positionData = new Tuple<String, Pair<Float, Float>, Integer>(keyData.getFirst().method_6621(), new Pair<Float, Float>(Float.valueOf((float)this.getScreenWidth() / 2.0f - 130.0f), Float.valueOf(this.getButtonY(this.currentAllocatedRow, 5))), 0xFFFFFF);
                if (!this.preRenderQueue.containsKey(this.currentAllocatedPage)) {
                    this.preRenderQueue.put(this.currentAllocatedPage, StringUtils.newArrayList(positionData));
                } else {
                    this.preRenderQueue.get(this.currentAllocatedPage).add(positionData);
                }
                if (!this.postRenderQueue.containsKey(this.currentAllocatedPage)) {
                    this.postRenderQueue.put(this.currentAllocatedPage, StringUtils.newArrayList(positionData));
                } else {
                    this.postRenderQueue.get(this.currentAllocatedPage).add(positionData);
                }
                ExtendedButtonControl keyCodeButton = new ExtendedButtonControl(renderPosition + 20, this.getButtonY(this.currentAllocatedRow), 120, 20, KeyUtils.getKeyName(keyData.getFirst().method_6623()), keyName);
                keyCodeButton.setOnClick(() -> this.setupEntryData(keyCodeButton, keyData));
                this.addControl(keyCodeButton, this.currentAllocatedPage);
                ++this.currentAllocatedRow;
                this.syncPageData();
            }
        }
    }

    private void syncPageData() {
        if (this.currentAllocatedRow >= 7) {
            ++this.currentAllocatedPage;
            this.currentAllocatedRow = 1;
        }
    }

    private void setupEntryData(ExtendedButtonControl button, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Tuple<ExtendedButtonControl, String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>>(button, button.getOptionalArgs()[0], keyData);
            this.backupKeyString = button.getControlMessage();
            button.setControlMessage("gui.config.message.editor.enter_key");
        }
    }

    private void setKeyData(int keyCode) {
        int keyToSubmit = keyCode;
        if (!KeyUtils.isValidKeyCode(keyToSubmit) || KeyUtils.isValidClearCode(keyToSubmit)) {
            keyToSubmit = 0;
        }
        String formattedKey = KeyUtils.getKeyName(keyToSubmit);
        try {
            this.entryData.getThird().getSecond().getSecond().accept(keyToSubmit, false);
            CraftPresence.KEYBINDINGS.keySyncQueue.put(this.entryData.getSecond(), keyToSubmit);
            CraftPresence.CONFIG.hasChanged = true;
            this.entryData.getFirst().setControlMessage(formattedKey);
        }
        catch (Throwable ex) {
            this.entryData.getFirst().setControlMessage(this.backupKeyString);
            Constants.LOG.debugError(ex);
        }
        this.backupKeyString = null;
        this.entryData = null;
    }
}

