/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.screen;

import javax.annotation.Nullable;

public class ScreenRectangle {
    private static final ScreenRectangle EMPTY = new ScreenRectangle(0, 0, 0, 0);
    private final int posX;
    private final int posY;
    private final int width;
    private final int height;

    public ScreenRectangle(int posX, int posY, int width, int height) {
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
    }

    public static ScreenRectangle empty() {
        return EMPTY;
    }

    @Nullable
    public ScreenRectangle intersection(ScreenRectangle rectangle) {
        int i = Math.max(this.getLeft(), rectangle.getLeft());
        int j = Math.max(this.getTop(), rectangle.getTop());
        int k = Math.min(this.getRight(), rectangle.getRight());
        int l = Math.min(this.getBottom(), rectangle.getBottom());
        return i < k && j < l ? new ScreenRectangle(i, j, k - i, l - j) : null;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.getPosY();
    }

    public int getBottom() {
        return this.getPosY() + this.getHeight();
    }

    public int getLeft() {
        return this.getPosX();
    }

    public int getRight() {
        return this.getPosX() + this.getWidth();
    }
}

