/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.generator.customization.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.gegy1000.terrarium.server.world.generator.customization.property.CycleEnumProperty;
import net.gegy1000.terrarium.server.world.generator.customization.property.EnumValue;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyKey;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyValue;

public class EnumKey<T extends Enum<T>>
extends PropertyKey<T> {
    private final Map<String, T> lookup = new Object2ObjectOpenHashMap();

    public EnumKey(String identifier, Class<T> type) {
        super(identifier, type);
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            this.lookup.put(((CycleEnumProperty)((Object)constant)).getKey(), constant);
        }
    }

    @Override
    public JsonElement serializeValue(PropertyValue<T> value) {
        return new JsonPrimitive(((CycleEnumProperty)((Object)((Enum)value.get()))).getKey());
    }

    @Override
    public PropertyValue<T> makeValue(T value) {
        return new EnumValue(this.getType(), value);
    }

    @Override
    @Nullable
    public PropertyValue<T> parseValue(JsonElement element) {
        String key;
        Enum value;
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && (value = (Enum)this.lookup.get(key = element.getAsString())) != null) {
            return new EnumValue<Enum>(this.getType(), value);
        }
        return null;
    }
}

