/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.generator.customization;

import com.google.gson.JsonObject;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.gegy1000.terrarium.server.world.generator.customization.PropertySchema;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TerrariumPreset {
    private final String name;
    private final ResourceLocation worldType;
    private final ResourceLocation icon;
    private final JsonObject properties;

    public TerrariumPreset(String name, ResourceLocation worldType, ResourceLocation icon, JsonObject properties) {
        this.name = name;
        this.worldType = worldType;
        this.icon = new ResourceLocation(icon.func_110624_b(), "textures/preset/" + icon.func_110623_a() + ".png");
        this.properties = properties;
    }

    public static TerrariumPreset parse(JsonObject root) {
        String name = JsonUtils.func_151200_h((JsonObject)root, (String)"name");
        ResourceLocation worldType = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)root, (String)"world_type"));
        ResourceLocation icon = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)root, (String)"icon"));
        JsonObject properties = JsonUtils.func_152754_s((JsonObject)root, (String)"properties");
        return new TerrariumPreset(name, worldType, icon, properties);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)("preset.terrarium." + this.worldType.func_110623_a() + "." + this.name + ".name"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDescription() {
        return I18n.func_135052_a((String)("preset.terrarium." + this.worldType.func_110623_a() + "." + this.name + ".desc"), (Object[])new Object[0]);
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public GenerationSettings createProperties(PropertySchema prototype) {
        return GenerationSettings.parse(prototype, this.properties);
    }

    public ResourceLocation getWorldType() {
        return this.worldType;
    }
}

