/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.source;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import net.gegy1000.justnow.Waker;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.justnow.future.JoinHandle;
import net.gegy1000.justnow.tuple.Unit;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.util.Profiler;
import net.gegy1000.terrarium.server.util.ThreadedProfiler;
import net.gegy1000.terrarium.server.util.Vec2i;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.source.DataTileResult;
import net.gegy1000.terrarium.server.world.data.source.ErrorBroadcastHandler;
import net.gegy1000.terrarium.server.world.data.source.TiledDataSource;
import net.minecraft.util.math.MathHelper;

public final class DataSourceReader {
    public static final DataSourceReader INSTANCE = new DataSourceReader();
    private final ExecutorService loadService = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("terrarium-data-loader-%s").setDaemon(true).build());
    private final Cache<TileKey<?>, DataTileResult<?>> tileCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private final Map<TileKey<?>, JoinHandle<DataTileResult<?>>> queuedTiles = new Object2ObjectOpenHashMap();
    private final LinkedBlockingDeque<Waker> queueEmpty = new LinkedBlockingDeque();
    private final Object lock = new Object();

    private DataSourceReader() {
    }

    public Future<Unit> finishLoading() {
        return waker -> {
            this.queueEmpty.add(waker);
            if (this.queuedTiles.isEmpty()) {
                return Unit.INSTANCE;
            }
            return null;
        };
    }

    private void notifyQueueEmpty() {
        while (!this.queueEmpty.isEmpty()) {
            Waker waker = this.queueEmpty.remove();
            waker.wake();
        }
    }

    public void clear() {
        this.cancelLoading();
        this.tileCache.invalidateAll();
    }

    public void cancelLoading() {
        for (JoinHandle<DataTileResult<?>> handle : this.queuedTiles.values()) {
            handle.cancel();
        }
        this.queuedTiles.clear();
        this.notifyQueueEmpty();
    }

    private <T> JoinHandle<DataTileResult<?>> enqueueTile(TileKey<T> key) {
        return Future.spawnBlocking(this.loadService, () -> {
            try {
                DataTileResult tile = this.loadTile(key);
                this.handleResult(key, tile);
                return tile;
            }
            catch (Throwable t) {
                this.logError(key, t);
                return DataTileResult.empty(key.getPos());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Future<DataTileResult<T>> getTile(TiledDataSource<T> source, int x, int y) {
        TileKey<T> key = new TileKey<T>(source, x, y);
        try {
            DataTileResult result = (DataTileResult)this.tileCache.getIfPresent(key);
            if (result != null) {
                return Future.ready(result);
            }
            Object object = this.lock;
            synchronized (object) {
                JoinHandle handle = this.queuedTiles.computeIfAbsent(key, this::enqueueTile);
                return handle;
            }
        }
        catch (Exception e) {
            Terrarium.LOGGER.warn("Unexpected error occurred at ({}; {}) from {}", (Object)x, (Object)y, (Object)source.getClass().getSimpleName(), (Object)e);
            ErrorBroadcastHandler.recordFailure();
            return Future.ready(DataTileResult.empty(key.getPos()));
        }
    }

    public <T> Future<Collection<DataTileResult<T>>> getTilesIntersecting(TiledDataSource<T> source, DataView view) {
        return this.getTilesIntersecting(source, view.minX(), view.minY(), view.maxX(), view.maxY());
    }

    public <T> Future<Collection<DataTileResult<T>>> getTilesIntersecting(TiledDataSource<T> source, double minX, double minY, double maxX, double maxY) {
        double tileWidth = source.getTileWidth();
        double tileHeight = source.getTileHeight();
        return this.getTiles(source, MathHelper.func_76128_c((double)(minX / tileWidth)), MathHelper.func_76128_c((double)(minY / tileHeight)), MathHelper.func_76128_c((double)(maxX / tileWidth)), MathHelper.func_76128_c((double)(maxY / tileHeight)));
    }

    private <T> Future<Collection<DataTileResult<T>>> getTiles(TiledDataSource<T> source, int minX, int minY, int maxX, int maxY) {
        ArrayList futures = new ArrayList((maxX - minX + 1) * (maxY - minY + 1));
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                futures.add(this.getTile(source, x, y));
            }
        }
        return Future.joinAll(futures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void handleResult(TileKey<T> key, DataTileResult<T> result) {
        Object object = this.lock;
        synchronized (object) {
            this.tileCache.put(key, result);
            this.queuedTiles.remove(key);
        }
        if (this.queuedTiles.isEmpty()) {
            this.notifyQueueEmpty();
        }
    }

    private <T> DataTileResult<T> loadTile(TileKey<T> key) throws IOException {
        Optional result;
        Vec2i pos = key.getPos();
        Profiler profiler = ThreadedProfiler.get();
        try (Profiler.Handle load = profiler.push("load_tile");){
            result = key.source.load(pos);
        }
        return new DataTileResult(pos, result);
    }

    private <T> void logError(TileKey<T> key, Throwable throwable) {
        String sourceName = key.source.getClass().getSimpleName();
        Terrarium.LOGGER.warn("[{}] Loading tile at {} raised error", (Object)sourceName, (Object)key.getPos(), (Object)throwable);
        ErrorBroadcastHandler.recordFailure();
    }

    private static class TileKey<T> {
        final TiledDataSource<T> source;
        final int x;
        final int y;

        TileKey(TiledDataSource<T> source, int x, int y) {
            this.source = source;
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TileKey) {
                TileKey key = (TileKey)o;
                return key.source == this.source && key.x == this.x && key.y == this.y;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.x + this.y;
        }

        Vec2i getPos() {
            return new Vec2i(this.x, this.y);
        }

        public String toString() {
            return "TileKey(" + this.x + "; " + this.y + ") @ " + this.source;
        }
    }
}

