/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.raster;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Optional;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.AbstractRaster;
import net.gegy1000.terrarium.server.world.data.raster.IntegerRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;

public final class ShortRaster
extends AbstractRaster<short[]>
implements IntegerRaster<short[]> {
    private ShortRaster(short[] data, int width, int height) {
        super(data, width, height);
    }

    public static ShortRaster create(int width, int height) {
        short[] array = new short[width * height];
        return new ShortRaster(array, width, height);
    }

    public static ShortRaster createSquare(int size) {
        return ShortRaster.create(size, size);
    }

    public static ShortRaster create(DataView view) {
        return ShortRaster.create(view.width(), view.height());
    }

    public static ShortRaster create(DataView view, int value) {
        ShortRaster raster = ShortRaster.create(view.width(), view.height());
        Arrays.fill((short[])raster.rawData, (short)value);
        return raster;
    }

    public static ShortRaster wrap(short[] data, int width, int height) {
        Preconditions.checkArgument((data.length == width * height ? 1 : 0) != 0, (Object)"invalid buffer size");
        return new ShortRaster(data, width, height);
    }

    public static Sampler sampler(DataKey<ShortRaster> key) {
        return new Sampler(key);
    }

    public void set(int x, int y, short value) {
        ((short[])this.rawData)[this.index((int)x, (int)y)] = value;
    }

    public short get(int x, int y) {
        return ((short[])this.rawData)[this.index(x, y)];
    }

    public void transform(Transformer transformer) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = this.index(x, y);
                ((short[])this.rawData)[index] = transformer.apply(((short[])this.rawData)[index], x, y);
            }
        }
    }

    public void iterate(Iterator iterator) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                iterator.accept(((short[])this.rawData)[this.index(x, y)], x, y);
            }
        }
    }

    @Override
    public void setFloat(int x, int y, float value) {
        this.set(x, y, (short)value);
    }

    @Override
    public float getFloat(int x, int y) {
        return this.get(x, y);
    }

    @Override
    public void setInt(int x, int y, int value) {
        this.set(x, y, (short)value);
    }

    @Override
    public int getInt(int x, int y) {
        return this.get(x, y);
    }

    public ShortRaster copy() {
        return new ShortRaster(Arrays.copyOf((short[])this.rawData, ((short[])this.rawData).length), this.width, this.height);
    }

    static class SampleCache {
        private static final int CAPACITY = 64;
        private static final int MASK = 63;
        static final short NULL = Short.MIN_VALUE;
        private final long[] keys = new long[64];
        private final short[] values;

        SampleCache() {
            Arrays.fill(this.keys, Long.MIN_VALUE);
            this.values = new short[64];
        }

        private static long key(int x, int z) {
            return (long)x << 32 | (long)z;
        }

        private static int hash(long key) {
            return HashCommon.long2int((long)HashCommon.mix((long)key));
        }

        void set(int x, int z, short value) {
            long key = SampleCache.key(x, z);
            int idx = SampleCache.hash(key) & 0x3F;
            this.values[idx] = value;
            this.keys[idx] = key;
        }

        short get(int x, int z) {
            long key = SampleCache.key(x, z);
            int idx = SampleCache.hash(key) & 0x3F;
            if (this.keys[idx] == key) {
                return this.values[idx];
            }
            return Short.MIN_VALUE;
        }
    }

    public static class Sampler
    implements Raster.Sampler<ShortRaster> {
        private final DataKey<ShortRaster> key;
        private short defaultValue;
        private SampleCache cache;

        Sampler(DataKey<ShortRaster> key) {
            this.key = key;
        }

        public Sampler defaultValue(int value) {
            this.defaultValue = (short)value;
            return this;
        }

        public Sampler cached() {
            this.cache = new SampleCache();
            return this;
        }

        public short sample(ColumnDataCache dataCache, int x, int z) {
            if (this.cache == null) {
                DataSample data = dataCache.joinData(x >> 4, z >> 4);
                return this.sample(data, x & 0xF, z & 0xF);
            }
            short cached = this.cache.get(x, z);
            if (cached != Short.MIN_VALUE) {
                return cached;
            }
            DataSample data = dataCache.joinData(x >> 4, z >> 4);
            short sample = this.sample(data, x & 0xF, z & 0xF);
            this.cache.set(x, z, sample);
            return sample;
        }

        public short sample(DataSample data, int x, int z) {
            Optional<ShortRaster> optional = data.get(this.key);
            if (optional.isPresent()) {
                ShortRaster raster = optional.get();
                return raster.get(x, z);
            }
            return this.defaultValue;
        }

        @Override
        public ShortRaster sample(ColumnDataCache dataCache, DataView view) {
            ShortRaster raster = ShortRaster.create(view);
            if (this.defaultValue != 0) {
                Arrays.fill((short[])raster.rawData, this.defaultValue);
            }
            AbstractRaster.sampleInto(raster, dataCache, view, this.key);
            return raster;
        }
    }

    public static interface Iterator {
        public void accept(short var1, int var2, int var3);
    }

    public static interface Transformer {
        public short apply(short var1, int var2, int var3);
    }
}

