/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.raster;

import java.util.function.BiFunction;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataView;

public interface Raster<T> {
    public int width();

    public int height();

    public T asRawData();

    default public int index(int x, int y) {
        return x + y * this.width();
    }

    default public DataView asView() {
        return DataView.of(this.width(), this.height());
    }

    public static <R extends Raster<?>> void rasterCopy(R src, DataView srcView, R dst, DataView dstView) {
        int minX = Math.max(0, dstView.minX() - srcView.minX());
        int minY = Math.max(0, dstView.minY() - srcView.minY());
        int maxX = Math.min(srcView.width(), dstView.maxX() - srcView.minX() + 1);
        int maxY = Math.min(srcView.height(), dstView.maxY() - srcView.minY() + 1);
        Object srcRaw = src.asRawData();
        Object dstRaw = dst.asRawData();
        for (int localY = minY; localY < maxY; ++localY) {
            int resultY = localY + srcView.minY() - dstView.minY();
            int localX = minX;
            int resultX = localX + srcView.minX() - dstView.minX();
            int sourceIndex = localX + localY * src.width();
            int resultIndex = resultX + resultY * dst.width();
            System.arraycopy(srcRaw, sourceIndex, dstRaw, resultIndex, maxX - minX);
        }
    }

    public static <R extends Raster<?>> void rasterCopy(R src, R dest) {
        int length = src.width() * src.height();
        System.arraycopy(src.asRawData(), 0, dest.asRawData(), 0, length);
    }

    public static interface Sampler<T>
    extends BiFunction<ColumnDataCache, DataView, T> {
        public T sample(ColumnDataCache var1, DataView var2);

        @Override
        default public T apply(ColumnDataCache dataCache, DataView view) {
            return this.sample(dataCache, view);
        }
    }
}

