/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.raster;

import java.util.Arrays;
import java.util.Optional;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.AbstractRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;

public final class EnumRaster<T extends Enum<T>>
extends AbstractRaster<byte[]> {
    private final Class<T> type;
    private final T[] universe;

    private EnumRaster(byte[] data, int width, int height, Class<T> type) {
        super(data, width, height);
        this.type = type;
        this.universe = (Enum[])type.getEnumConstants();
        if (this.universe.length > 255) {
            throw new IllegalStateException("Enum has too many variants!");
        }
    }

    public static <T extends Enum<T>> EnumRaster<T> create(T variant, int width, int height) {
        Class<?> type = variant.getClass();
        byte[] array = new byte[width * height];
        Arrays.fill(array, (byte)variant.ordinal());
        return new EnumRaster(array, width, height, type);
    }

    public static <T extends Enum<T>> EnumRaster<T> createSquare(T variant, int size) {
        return EnumRaster.create(variant, size, size);
    }

    public static <T extends Enum<T>> EnumRaster<T> create(T variant, DataView view) {
        return EnumRaster.create(variant, view.width(), view.height());
    }

    public static <T extends Enum<T>> Sampler<T> sampler(DataKey<EnumRaster<T>> key, T defaultVariant) {
        return new Sampler<T>(key, defaultVariant);
    }

    public void set(int x, int y, T variant) {
        ((byte[])this.rawData)[this.index((int)x, (int)y)] = (byte)((Enum)variant).ordinal();
    }

    public T get(int x, int y) {
        return this.universe[((byte[])this.rawData)[this.index(x, y)] & 0xFF];
    }

    public void transform(Transformer<T> transformer) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = this.index(x, y);
                T variant = this.universe[((byte[])this.rawData)[index] & 0xFF];
                ((byte[])this.rawData)[index] = (byte)((Enum)transformer.apply(variant, x, y)).ordinal();
            }
        }
    }

    public void iterate(Iterator<T> iterator) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                T variant = this.universe[((byte[])this.rawData)[this.index(x, y)] & 0xFF];
                iterator.accept(variant, x, y);
            }
        }
    }

    public EnumRaster<T> copy() {
        return new EnumRaster<T>(Arrays.copyOf((byte[])this.rawData, ((byte[])this.rawData).length), this.width, this.height, this.type);
    }

    public static class Sampler<T extends Enum<T>>
    implements Raster.Sampler<EnumRaster<T>> {
        private final DataKey<EnumRaster<T>> key;
        private final T defaultVariant;

        Sampler(DataKey<EnumRaster<T>> key, T defaultVariant) {
            this.key = key;
            this.defaultVariant = defaultVariant;
        }

        public T sample(ColumnDataCache dataCache, int x, int z) {
            DataSample data = dataCache.joinData(x >> 4, z >> 4);
            return this.sample(data, x & 0xF, z & 0xF);
        }

        public T sample(DataSample data, int x, int z) {
            Optional<EnumRaster<T>> optional = data.get(this.key);
            if (optional.isPresent()) {
                EnumRaster<T> raster = optional.get();
                return raster.get(x, z);
            }
            return this.defaultVariant;
        }

        @Override
        public EnumRaster<T> sample(ColumnDataCache dataCache, DataView view) {
            EnumRaster<T> raster = EnumRaster.create(this.defaultVariant, view);
            AbstractRaster.sampleInto(raster, dataCache, view, this.key);
            return raster;
        }
    }

    public static interface Iterator<T extends Enum<T>> {
        public void accept(T var1, int var2, int var3);
    }

    public static interface Transformer<T extends Enum<T>> {
        public T apply(T var1, int var2, int var3);
    }
}

