/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.op;

import net.gegy1000.terrarium.server.util.Profiler;
import net.gegy1000.terrarium.server.util.ThreadedProfiler;
import net.gegy1000.terrarium.server.util.Voronoi;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.gegy1000.terrarium.server.world.data.DataOp;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.minecraft.util.math.MathHelper;

public final class VoronoiScaleOp {
    private static final long SEED = 2016969737595986194L;

    public static <T extends Enum<T>> DataOp<EnumRaster<T>> scaleEnumsFrom(DataOp<EnumRaster<T>> data, CoordinateReference src, T defaultValue) {
        Voronoi voronoi = new Voronoi(0.45f, 2016969737595986194L);
        return DataOp.of((view, ctx) -> {
            DataView srcView = VoronoiScaleOp.getSourceView(view, src);
            float dstToSrcX = (float)(1.0 / src.scaleX());
            float dstToSrcY = (float)(1.0 / src.scaleZ());
            Coordinate minCoordinate = Coordinate.min(view.minCoordinate().to(src), view.maxCoordinate().to(src));
            float offsetX = (float)(minCoordinate.x() - (double)srcView.minX());
            float offsetY = (float)(minCoordinate.z() - (double)srcView.minY());
            return data.apply(srcView, ctx).andThen(opt -> ctx.spawnBlocking(() -> opt.map(source -> {
                Profiler profiler = ThreadedProfiler.get();
                try (Profiler.Handle scaleRaster = profiler.push("voronoi_raster");){
                    EnumRaster<Enum> result = EnumRaster.create(defaultValue, view);
                    voronoi.scaleBytes((byte[])source.asRawData(), (byte[])result.asRawData(), srcView, view, dstToSrcX, dstToSrcY, offsetX, offsetY);
                    EnumRaster<Enum> enumRaster = result;
                    return enumRaster;
                }
            })));
        });
    }

    private static DataView getSourceView(DataView view, CoordinateReference src) {
        Coordinate minSourceBlock = view.minCoordinate().to(src);
        Coordinate maxSourceBlock = view.maxCoordinate().to(src);
        Coordinate minSource = Coordinate.min(minSourceBlock, maxSourceBlock);
        Coordinate maxSource = Coordinate.max(minSourceBlock, maxSourceBlock);
        int minSourceX = MathHelper.func_76128_c((double)minSource.x()) - 1;
        int minSourceY = MathHelper.func_76128_c((double)minSource.z()) - 1;
        int maxSourceX = MathHelper.func_76128_c((double)maxSource.x()) + 1;
        int maxSourceY = MathHelper.func_76128_c((double)maxSource.z()) + 1;
        return DataView.ofCorners(minSourceX, minSourceY, maxSourceX, maxSourceY);
    }
}

