/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.op;

import java.util.function.Function;
import net.gegy1000.terrarium.server.util.Interpolate;
import net.gegy1000.terrarium.server.util.Profiler;
import net.gegy1000.terrarium.server.util.ThreadedProfiler;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.gegy1000.terrarium.server.world.data.DataOp;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.NumberRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.minecraft.util.math.MathHelper;

public enum InterpolationScaleOp {
    NEAREST(Interpolate.NEAREST),
    LINEAR(Interpolate.LINEAR),
    COSINE(Interpolate.COSINE),
    CUBIC(Interpolate.CUBIC);

    private final Interpolate interpolate;
    private final ThreadLocal<double[][]> kernel2;
    private final ThreadLocal<double[]> kernel1;

    private InterpolationScaleOp(Interpolate interpolate) {
        this.interpolate = interpolate;
        int kernelWidth = this.interpolate.getKernel().getWidth();
        this.kernel2 = ThreadLocal.withInitial(() -> new double[kernelWidth][kernelWidth]);
        this.kernel1 = ThreadLocal.withInitial(() -> new double[kernelWidth]);
    }

    public static InterpolationScaleOp appropriateForScale(double relativeScale) {
        if (relativeScale <= 1.0) {
            return NEAREST;
        }
        if (relativeScale <= 2.0) {
            return LINEAR;
        }
        if (relativeScale <= 3.0) {
            return COSINE;
        }
        return CUBIC;
    }

    public DataOp<ShortRaster> scaleShortsFrom(DataOp<ShortRaster> data, CoordinateReference src) {
        return this.scaleFrom(data, src, ShortRaster::create);
    }

    public DataOp<FloatRaster> scaleFloatsFrom(DataOp<FloatRaster> data, CoordinateReference src) {
        return this.scaleFrom(data, src, FloatRaster::create);
    }

    public <T extends NumberRaster<?>> DataOp<T> scaleFrom(DataOp<T> data, CoordinateReference src, Function<DataView, T> function) {
        return DataOp.of((view, ctx) -> {
            DataView srcView = this.getSourceView(view, src);
            double dstToSrcX = 1.0 / src.scaleX();
            double dstToSrcY = 1.0 / src.scaleZ();
            Coordinate minCoordinate = Coordinate.min(view.minCoordinate().to(src), view.maxCoordinate().to(src));
            double offsetX = minCoordinate.x() - (double)srcView.minX();
            double offsetY = minCoordinate.z() - (double)srcView.minY();
            return data.apply(srcView, ctx).andThen(opt -> ctx.spawnBlocking(() -> opt.map(source -> {
                NumberRaster result = (NumberRaster)function.apply(view);
                Profiler profiler = ThreadedProfiler.get();
                try (Profiler.Handle scaleRaster = profiler.push("interpolate_raster");){
                    if (this == NEAREST) {
                        this.scaleIntoNearest((NumberRaster)source, (NumberRaster)result, dstToSrcX, dstToSrcY, offsetX, offsetY);
                    } else {
                        this.scaleInto((NumberRaster)source, (NumberRaster)result, dstToSrcX, dstToSrcY, offsetX, offsetY);
                    }
                    NumberRaster numberRaster = result;
                    return numberRaster;
                }
            })));
        });
    }

    private <T extends NumberRaster<?>> void scaleInto(T src, T dst, double dstToSrcX, double dstToSrcY, double offsetX, double offsetY) {
        double[][] kernel2 = this.kernel2.get();
        double[] kernel1 = this.kernel1.get();
        for (int y = 0; y < dst.height(); ++y) {
            for (int x = 0; x < dst.width(); ++x) {
                float value = this.evaluate(kernel1, kernel2, src, (double)x * dstToSrcX + offsetX - 0.5, (double)y * dstToSrcY + offsetY - 0.5);
                dst.setFloat(x, y, value);
            }
        }
    }

    private <T extends NumberRaster<?>> void scaleIntoNearest(T src, T dst, double dstToSrcX, double dstToSrcY, double offsetX, double offsetY) {
        for (int y = 0; y < dst.height(); ++y) {
            for (int x = 0; x < dst.width(); ++x) {
                int srcX = MathHelper.func_76128_c((double)((double)x * dstToSrcX + offsetX - 0.5));
                int srcY = MathHelper.func_76128_c((double)((double)y * dstToSrcY + offsetY - 0.5));
                dst.setFloat(x, y, src.getFloat(srcX, srcY));
            }
        }
    }

    private <T extends NumberRaster<?>> float evaluate(double[] kernel1, double[][] kernel2, T source, double x, double y) {
        int originX = MathHelper.func_76128_c((double)x);
        int originY = MathHelper.func_76128_c((double)y);
        this.sampleKernel(source, kernel2, originX, originY);
        double intermediateX = x - (double)originX;
        double intermediateY = y - (double)originY;
        return (float)this.interpolate.evaluate(kernel2, intermediateX, intermediateY, kernel1);
    }

    private <T extends NumberRaster<?>> void sampleKernel(T source, double[][] buffer, int x, int y) {
        Interpolate.Kernel kernel = this.interpolate.getKernel();
        int kernelWidth = kernel.getWidth();
        int kernelOffset = kernel.getOffset();
        for (int kernelY = 0; kernelY < kernelWidth; ++kernelY) {
            int sourceY = y + kernelY + kernelOffset;
            for (int kernelX = 0; kernelX < kernelWidth; ++kernelX) {
                int sourceX = x + kernelX + kernelOffset;
                buffer[kernelX][kernelY] = source.getFloat(sourceX, sourceY);
            }
        }
    }

    private DataView getSourceView(DataView view, CoordinateReference crs) {
        Coordinate minSourceBlock = view.minCoordinate().to(crs);
        Coordinate maxSourceBlock = view.maxCoordinate().to(crs);
        Coordinate minSource = Coordinate.min(minSourceBlock, maxSourceBlock);
        Coordinate maxSource = Coordinate.max(minSourceBlock, maxSourceBlock);
        Interpolate.Kernel kernel = this.interpolate.getKernel();
        int kernelOffset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int minSourceX = MathHelper.func_76128_c((double)(minSource.x() + (double)kernelOffset - 0.5));
        int minSourceY = MathHelper.func_76128_c((double)(minSource.z() + (double)kernelOffset - 0.5));
        int maxSourceX = MathHelper.func_76128_c((double)(maxSource.x() + (double)kernelOffset + (double)kernelWidth - 0.5));
        int maxSourceY = MathHelper.func_76128_c((double)(maxSource.z() + (double)kernelOffset + (double)kernelWidth - 0.5));
        return DataView.ofCorners(minSourceX, minSourceY, maxSourceX, maxSourceY);
    }
}

