/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.chunk.tracker;

import io.github.opencubicchunks.cubicchunks.api.util.CubePos;
import io.github.opencubicchunks.cubicchunks.core.server.CubeWatcher;
import io.github.opencubicchunks.cubicchunks.core.server.PlayerCubeMap;
import io.github.opencubicchunks.cubicchunks.core.util.WatchersSortingList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.chunk.tracker.ChunkTrackerAccess;
import net.gegy1000.terrarium.server.world.chunk.tracker.SavedCubeTracker;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CubeTrackerAccess
implements ChunkTrackerAccess {
    private static final LongSortedSet EMPTY = new LongLinkedOpenHashSet();
    private static Field cubesToGenerateField;
    private final WorldServer world;
    private final LongSortedSet bufferColumns = new LongLinkedOpenHashSet();

    public CubeTrackerAccess(WorldServer world) {
        this.world = world;
    }

    @Override
    public LongSortedSet getSortedQueuedColumns() {
        PlayerChunkMap chunkTracker = this.world.func_184164_w();
        if (chunkTracker instanceof PlayerCubeMap) {
            WatchersSortingList<CubeWatcher> cubesToGenerate = CubeTrackerAccess.getCubesToGenerate((PlayerCubeMap)chunkTracker);
            if (cubesToGenerate == null) {
                return EMPTY;
            }
            LongLinkedOpenHashSet queuedColumns = new LongLinkedOpenHashSet();
            this.bufferColumns.clear();
            for (CubeWatcher watcher : cubesToGenerate) {
                CubePos cubePos;
                boolean queued;
                long key = ChunkPos.func_77272_a((int)watcher.getX(), (int)watcher.getZ());
                if (queuedColumns.contains(key) || !(queued = !SavedCubeTracker.isSaved((World)this.world, cubePos = new CubePos(watcher.getX(), watcher.getY(), watcher.getZ())))) continue;
                queuedColumns.add(key);
                for (int z = -6; z <= 6; ++z) {
                    for (int x = -6; x <= 6; ++x) {
                        if (x == 0 && z == 0) continue;
                        this.bufferColumns.add(ChunkPos.func_77272_a((int)(x + cubePos.getX()), (int)(z + cubePos.getZ())));
                    }
                }
            }
            queuedColumns.addAll((LongCollection)this.bufferColumns);
            return queuedColumns;
        }
        return EMPTY;
    }

    @Nullable
    private static WatchersSortingList<CubeWatcher> getCubesToGenerate(PlayerCubeMap cubeTracker) {
        if (cubesToGenerateField != null) {
            try {
                return (WatchersSortingList)cubesToGenerateField.get(cubeTracker);
            }
            catch (ReflectiveOperationException e) {
                Terrarium.LOGGER.error("Failed to get cubes to generate", (Throwable)e);
            }
        }
        return null;
    }

    static {
        try {
            cubesToGenerateField = PlayerCubeMap.class.getDeclaredField("cubesToGenerate");
            cubesToGenerateField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Terrarium.LOGGER.error("Failed to find cube to generate field", (Throwable)e);
        }
    }
}

