/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.gegy1000.terrarium.client.gui.GuiRenderUtils;
import net.gegy1000.terrarium.client.gui.widget.TooltipRenderer;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ToggleGuiWidget
extends GuiButtonExt
implements TooltipRenderer {
    private final PropertyPair<Boolean> property;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private boolean state;
    private float hoverTime;
    private boolean locked;

    public ToggleGuiWidget(PropertyPair<Boolean> property) {
        super(0, 0, 0, 150, 20, "");
        this.property = property;
        this.setState((Boolean)property.value.get());
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.field_146124_l = !locked;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            this.hoverTime = this.isSelected(mouseX, mouseY) ? (this.hoverTime += partialTicks) : 0.0f;
        }
    }

    @Override
    public void renderTooltip(int mouseX, int mouseY) {
        if (this.hoverTime >= 15.0f) {
            List<String> lines = this.getTooltip();
            GuiRenderUtils.drawTooltip(lines, mouseX, mouseY);
        }
    }

    private List<String> getTooltip() {
        if (this.locked) {
            return Lists.newArrayList((Object[])new String[]{TextFormatting.GRAY + I18n.func_135052_a((String)"property.terrarium.locked.name", (Object[])new Object[0])});
        }
        String name = TextFormatting.BLUE + this.property.key.getLocalizedName();
        String tooltip = TextFormatting.GRAY + this.property.key.getLocalizedTooltip();
        return Lists.newArrayList((Object[])new String[]{name, tooltip});
    }

    public void setState(boolean state) {
        if (state != this.state) {
            this.property.value.set(state);
            for (Runnable listener : this.listeners) {
                listener.run();
            }
        }
        this.state = state;
        String stateKey = I18n.func_135052_a((String)(this.state ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        stateKey = this.state ? TextFormatting.GREEN + stateKey : TextFormatting.RED + stateKey;
        this.field_146126_j = String.format("%s: %s", this.property.key.getLocalizedName(), stateKey);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY)) {
            if (!this.locked) {
                this.setState(!this.state);
            }
            return true;
        }
        return false;
    }

    private boolean isSelected(int mouseX, int mouseY) {
        return this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
    }
}

