/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client.gui.widget;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import net.gegy1000.terrarium.client.gui.customization.SelectPresetGui;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPreset;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPresetRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PresetList
extends GuiListExtended {
    private static final ResourceLocation FALLBACK_ICON = new ResourceLocation("terrarium", "textures/preset/fallback.png");
    private static final ResourceLocation ICON_OVERLAY = new ResourceLocation("textures/gui/world_selection.png");
    private final SelectPresetGui parent;
    private final ImmutableList<PresetEntry> entries;
    private int selectedIndex = -1;

    public PresetList(Minecraft mc, SelectPresetGui parent, TerrariumWorldType worldType) {
        super(mc, parent.field_146294_l, parent.field_146295_m, 32, parent.field_146295_m - 64, 36);
        this.parent = parent;
        TerrariumPreset defaultPreset = worldType.getPreset();
        ImmutableList.Builder entryBuilder = ImmutableList.builder();
        entryBuilder.add((Object)new PresetEntry(mc, defaultPreset));
        for (TerrariumPreset preset : TerrariumPresetRegistry.getPresets()) {
            if (preset == defaultPreset || !preset.getWorldType().equals((Object)worldType.getIdentifier())) continue;
            entryBuilder.add((Object)new PresetEntry(mc, preset));
        }
        this.entries = entryBuilder.build();
        this.selectPreset(0);
    }

    public void selectPreset(int index) {
        if (index >= 0 && index < this.entries.size()) {
            PresetEntry entry = (PresetEntry)this.entries.get(index);
            this.parent.selectPreset(entry.preset);
            this.selectedIndex = index;
        } else {
            this.selectedIndex = -1;
        }
    }

    public void applyPreset() {
        this.parent.applyPreset();
    }

    public int func_148139_c() {
        return super.func_148139_c() + 50;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 20;
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return (GuiListExtended.IGuiListEntry)this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.selectedIndex;
    }

    public class PresetEntry
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft mc;
        final TerrariumPreset preset;
        private final ResourceLocation icon;
        private long lastClickTime;

        public PresetEntry(Minecraft mc, TerrariumPreset preset) {
            this.mc = mc;
            this.preset = preset;
            this.icon = preset.getIcon();
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.mc.field_71466_p.func_78276_b(this.preset.getLocalizedName(), x + 32 + 3, y + 1, 0xFFFFFF);
            String description = TextFormatting.DARK_GRAY + this.preset.getLocalizedDescription();
            this.mc.field_71466_p.func_78279_b(description, x + 32 + 3, y + this.mc.field_71466_p.field_78288_b + 3, listWidth - 40, 0xFFFFFF);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureManager textureManager = this.mc.func_110434_K();
            textureManager.func_110577_a(this.computeIcon());
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            if (this.mc.field_71474_y.field_85185_A || isSelected) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + 32), (int)(y + 32), (int)-1601138544);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                textureManager.func_110577_a(ICON_OVERLAY);
                Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)(mouseX - x < 32 ? 32.0f : 0.0f), (int)32, (int)32, (float)256.0f, (float)256.0f);
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            PresetList.this.selectPreset(slotIndex);
            if (relativeX < 32 || System.currentTimeMillis() - this.lastClickTime < 250L) {
                PresetList.this.applyPreset();
                return true;
            }
            this.lastClickTime = System.currentTimeMillis();
            return false;
        }

        public void func_148277_b(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ResourceLocation computeIcon() {
            if (this.mc.func_110434_K().func_110581_b(this.icon) != null) {
                return this.icon;
            }
            try (IResource resource = this.mc.func_110442_L().func_110536_a(this.icon);){
                if (resource == null) return FALLBACK_ICON;
                ResourceLocation resourceLocation = this.icon;
                return resourceLocation;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FALLBACK_ICON;
        }
    }
}

