/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.vegetation;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.writer.ChunkPopulationWriter;
import java.util.Random;
import net.gegy1000.earth.server.world.ecology.vegetation.VegetationGenerator;
import net.gegy1000.terrarium.server.util.WeightedPool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public final class FlowerDecorator {
    private static final NoiseGeneratorPerlin SAMPLE_NOISE = new NoiseGeneratorPerlin(new Random(123L), 1);
    private final WeightedPool<VegetationGenerator> pool = new WeightedPool();
    private float countPerChunk = 1.0f;
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public FlowerDecorator setCountPerChunk(float countPerChunk) {
        this.countPerChunk = countPerChunk;
        return this;
    }

    public FlowerDecorator add(VegetationGenerator vegetation, float weight) {
        this.pool.add(vegetation, weight);
        return this;
    }

    public void decorate(ChunkPopulationWriter writer, CubicPos cubePos, Random random) {
        if (this.pool.isEmpty()) {
            return;
        }
        World world = writer.getGlobal();
        int minX = cubePos.getCenterX();
        int minZ = cubePos.getCenterZ();
        int count = MathHelper.func_76141_d((float)this.countPerChunk);
        float remainder = this.countPerChunk - (float)count;
        if (random.nextFloat() < remainder) {
            ++count;
        }
        for (int i = 0; i < count; ++i) {
            VegetationGenerator vegetation;
            int x = minX + random.nextInt(16);
            int z = minZ + random.nextInt(16);
            this.mutablePos.func_181079_c(x, 0, z);
            if (!writer.getSurfaceMut(this.mutablePos) || (vegetation = this.pool.sampleOrNull(FlowerDecorator.noise(x, z))) == null) continue;
            vegetation.generate(world, random, (BlockPos)this.mutablePos);
        }
    }

    private static float noise(double x, double z) {
        float noise = (float)SAMPLE_NOISE.func_151601_a(x / 48.0, z / 48.0);
        return MathHelper.func_76131_a((float)((1.0f + noise) / 2.0f), (float)0.0f, (float)1.0f);
    }
}

